/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.lookup;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.painless.lookup.PainlessClass;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;

public final class PainlessLookup {
    private final Map<String, Class<?>> javaClassNamesToClasses;
    private final Map<String, Class<?>> canonicalClassNamesToClasses;
    private final Map<Class<?>, PainlessClass> classesToPainlessClasses;
    private final Map<Class<?>, Set<Class<?>>> classesToDirectSubClasses;
    private final Map<String, PainlessMethod> painlessMethodKeysToImportedPainlessMethods;
    private final Map<String, PainlessClassBinding> painlessMethodKeysToPainlessClassBindings;
    private final Map<String, PainlessInstanceBinding> painlessMethodKeysToPainlessInstanceBindings;

    PainlessLookup(Map<String, Class<?>> javaClassNamesToClasses, Map<String, Class<?>> canonicalClassNamesToClasses, Map<Class<?>, PainlessClass> classesToPainlessClasses, Map<Class<?>, Set<Class<?>>> classesToDirectSubClasses, Map<String, PainlessMethod> painlessMethodKeysToImportedPainlessMethods, Map<String, PainlessClassBinding> painlessMethodKeysToPainlessClassBindings, Map<String, PainlessInstanceBinding> painlessMethodKeysToPainlessInstanceBindings) {
        Objects.requireNonNull(javaClassNamesToClasses);
        Objects.requireNonNull(canonicalClassNamesToClasses);
        Objects.requireNonNull(classesToPainlessClasses);
        Objects.requireNonNull(classesToDirectSubClasses);
        Objects.requireNonNull(painlessMethodKeysToImportedPainlessMethods);
        Objects.requireNonNull(painlessMethodKeysToPainlessClassBindings);
        Objects.requireNonNull(painlessMethodKeysToPainlessInstanceBindings);
        this.javaClassNamesToClasses = javaClassNamesToClasses;
        this.canonicalClassNamesToClasses = CollectionUtils.copyMap(canonicalClassNamesToClasses);
        this.classesToPainlessClasses = CollectionUtils.copyMap(classesToPainlessClasses);
        this.classesToDirectSubClasses = CollectionUtils.copyMap(classesToDirectSubClasses);
        this.painlessMethodKeysToImportedPainlessMethods = CollectionUtils.copyMap(painlessMethodKeysToImportedPainlessMethods);
        this.painlessMethodKeysToPainlessClassBindings = CollectionUtils.copyMap(painlessMethodKeysToPainlessClassBindings);
        this.painlessMethodKeysToPainlessInstanceBindings = CollectionUtils.copyMap(painlessMethodKeysToPainlessInstanceBindings);
    }

    public Class<?> javaClassNameToClass(String javaClassName) {
        return this.javaClassNamesToClasses.get(javaClassName);
    }

    public boolean isValidCanonicalClassName(String canonicalClassName) {
        Objects.requireNonNull(canonicalClassName);
        return "def".equals(canonicalClassName) || this.canonicalClassNamesToClasses.containsKey(canonicalClassName);
    }

    public Class<?> canonicalTypeNameToType(String canonicalTypeName) {
        Objects.requireNonNull(canonicalTypeName);
        return PainlessLookupUtility.canonicalTypeNameToType(canonicalTypeName, this.canonicalClassNamesToClasses);
    }

    public Set<Class<?>> getClasses() {
        return this.classesToPainlessClasses.keySet();
    }

    public Set<Class<?>> getDirectSubClasses(Class<?> superClass) {
        return this.classesToDirectSubClasses.get(superClass);
    }

    public Set<String> getImportedPainlessMethodsKeys() {
        return this.painlessMethodKeysToImportedPainlessMethods.keySet();
    }

    public Set<String> getPainlessClassBindingsKeys() {
        return this.painlessMethodKeysToPainlessClassBindings.keySet();
    }

    public Set<String> getPainlessInstanceBindingsKeys() {
        return this.painlessMethodKeysToPainlessInstanceBindings.keySet();
    }

    public PainlessClass lookupPainlessClass(Class<?> targetClass) {
        return this.classesToPainlessClasses.get(targetClass);
    }

    public PainlessConstructor lookupPainlessConstructor(String targetCanonicalClassName, int constructorArity) {
        Objects.requireNonNull(targetCanonicalClassName);
        Class<?> targetClass = this.canonicalTypeNameToType(targetCanonicalClassName);
        if (targetClass == null) {
            return null;
        }
        return this.lookupPainlessConstructor(targetClass, constructorArity);
    }

    public PainlessConstructor lookupPainlessConstructor(Class<?> targetClass, int constructorArity) {
        Objects.requireNonNull(targetClass);
        PainlessClass targetPainlessClass = this.classesToPainlessClasses.get(targetClass);
        String painlessConstructorKey = PainlessLookupUtility.buildPainlessConstructorKey(constructorArity);
        if (targetPainlessClass == null) {
            return null;
        }
        PainlessConstructor painlessConstructor = targetPainlessClass.constructors.get(painlessConstructorKey);
        if (painlessConstructor == null) {
            return null;
        }
        return painlessConstructor;
    }

    public PainlessMethod lookupPainlessMethod(String targetCanonicalClassName, boolean isStatic, String methodName, int methodArity) {
        Objects.requireNonNull(targetCanonicalClassName);
        Class<?> targetClass = this.canonicalTypeNameToType(targetCanonicalClassName);
        if (targetClass == null) {
            return null;
        }
        return this.lookupPainlessMethod(targetClass, isStatic, methodName, methodArity);
    }

    public PainlessMethod lookupPainlessMethod(Class<?> targetClass, boolean isStatic, String methodName, int methodArity) {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        if (!this.classesToPainlessClasses.containsKey(targetClass)) {
            return null;
        }
        if (targetClass.isPrimitive() && !this.classesToPainlessClasses.containsKey(targetClass = PainlessLookupUtility.typeToBoxedType(targetClass))) {
            return null;
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, methodArity);
        Function<PainlessClass, PainlessMethod> objectLookup = isStatic ? targetPainlessClass -> targetPainlessClass.staticMethods.get(painlessMethodKey) : targetPainlessClass -> targetPainlessClass.methods.get(painlessMethodKey);
        return this.lookupPainlessObject(targetClass, objectLookup);
    }

    public List<PainlessMethod> lookupPainlessSubClassesMethod(String targetCanonicalClassName, String methodName, int methodArity) {
        Objects.requireNonNull(targetCanonicalClassName);
        Class<?> targetClass = this.canonicalTypeNameToType(targetCanonicalClassName);
        if (targetClass == null) {
            return null;
        }
        return this.lookupPainlessSubClassesMethod(targetClass, methodName, methodArity);
    }

    public List<PainlessMethod> lookupPainlessSubClassesMethod(Class<?> targetClass, String methodName, int methodArity) {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        if (!this.classesToPainlessClasses.containsKey(targetClass)) {
            return null;
        }
        if (targetClass.isPrimitive() && !this.classesToPainlessClasses.containsKey(targetClass = PainlessLookupUtility.typeToBoxedType(targetClass))) {
            return null;
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, methodArity);
        ArrayList subClasses = new ArrayList(this.classesToDirectSubClasses.get(targetClass));
        HashSet<Class> resolvedSubClasses = new HashSet<Class>();
        ArrayList<PainlessMethod> subMethods = null;
        while (!subClasses.isEmpty()) {
            Class subClass = (Class)subClasses.remove(0);
            if (!resolvedSubClasses.add(subClass)) continue;
            subClasses.addAll(this.classesToDirectSubClasses.get(subClass));
            PainlessClass painlessClass = this.classesToPainlessClasses.get(subClass);
            PainlessMethod painlessMethod = painlessClass.methods.get(painlessMethodKey);
            if (painlessMethod == null) continue;
            if (subMethods == null) {
                subMethods = new ArrayList<PainlessMethod>();
            }
            subMethods.add(painlessMethod);
        }
        return subMethods;
    }

    public PainlessField lookupPainlessField(String targetCanonicalClassName, boolean isStatic, String fieldName) {
        Objects.requireNonNull(targetCanonicalClassName);
        Class<?> targetClass = this.canonicalTypeNameToType(targetCanonicalClassName);
        if (targetClass == null) {
            return null;
        }
        return this.lookupPainlessField(targetClass, isStatic, fieldName);
    }

    public PainlessField lookupPainlessField(Class<?> targetClass, boolean isStatic, String fieldName) {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(fieldName);
        if (!this.classesToPainlessClasses.containsKey(targetClass)) {
            return null;
        }
        String painlessFieldKey = PainlessLookupUtility.buildPainlessFieldKey(fieldName);
        Function<PainlessClass, PainlessField> objectLookup = isStatic ? targetPainlessClass -> targetPainlessClass.staticFields.get(painlessFieldKey) : targetPainlessClass -> targetPainlessClass.fields.get(painlessFieldKey);
        return this.lookupPainlessObject(targetClass, objectLookup);
    }

    public PainlessMethod lookupImportedPainlessMethod(String methodName, int arity) {
        Objects.requireNonNull(methodName);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, arity);
        return this.painlessMethodKeysToImportedPainlessMethods.get(painlessMethodKey);
    }

    public PainlessClassBinding lookupPainlessClassBinding(String methodName, int arity) {
        Objects.requireNonNull(methodName);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, arity);
        return this.painlessMethodKeysToPainlessClassBindings.get(painlessMethodKey);
    }

    public PainlessInstanceBinding lookupPainlessInstanceBinding(String methodName, int arity) {
        Objects.requireNonNull(methodName);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, arity);
        return this.painlessMethodKeysToPainlessInstanceBindings.get(painlessMethodKey);
    }

    public PainlessMethod lookupFunctionalInterfacePainlessMethod(Class<?> targetClass) {
        PainlessClass targetPainlessClass = this.classesToPainlessClasses.get(targetClass);
        if (targetPainlessClass == null) {
            return null;
        }
        return targetPainlessClass.functionalInterfaceMethod;
    }

    public PainlessMethod lookupRuntimePainlessMethod(Class<?> originalTargetClass, String methodName, int methodArity) {
        Objects.requireNonNull(originalTargetClass);
        Objects.requireNonNull(methodName);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, methodArity);
        Function<PainlessClass, PainlessMethod> objectLookup = targetPainlessClass -> targetPainlessClass.runtimeMethods.get(painlessMethodKey);
        return this.lookupPainlessObject(originalTargetClass, objectLookup);
    }

    public MethodHandle lookupRuntimeGetterMethodHandle(Class<?> originalTargetClass, String getterName) {
        Objects.requireNonNull(originalTargetClass);
        Objects.requireNonNull(getterName);
        Function<PainlessClass, MethodHandle> objectLookup = targetPainlessClass -> targetPainlessClass.getterMethodHandles.get(getterName);
        return this.lookupPainlessObject(originalTargetClass, objectLookup);
    }

    public MethodHandle lookupRuntimeSetterMethodHandle(Class<?> originalTargetClass, String setterName) {
        Objects.requireNonNull(originalTargetClass);
        Objects.requireNonNull(setterName);
        Function<PainlessClass, MethodHandle> objectLookup = targetPainlessClass -> targetPainlessClass.setterMethodHandles.get(setterName);
        return this.lookupPainlessObject(originalTargetClass, objectLookup);
    }

    private <T> T lookupPainlessObject(Class<?> originalTargetClass, Function<PainlessClass, T> objectLookup) {
        T painlessObject;
        PainlessClass targetPainlessClass;
        Class<?> currentTargetClass;
        Objects.requireNonNull(originalTargetClass);
        Objects.requireNonNull(objectLookup);
        for (currentTargetClass = originalTargetClass; currentTargetClass != null; currentTargetClass = currentTargetClass.getSuperclass()) {
            targetPainlessClass = this.classesToPainlessClasses.get(currentTargetClass);
            if (targetPainlessClass == null || (painlessObject = objectLookup.apply(targetPainlessClass)) == null) continue;
            return painlessObject;
        }
        if (originalTargetClass.isInterface() && (targetPainlessClass = this.classesToPainlessClasses.get(Object.class)) != null && (painlessObject = objectLookup.apply(targetPainlessClass)) != null) {
            return painlessObject;
        }
        HashSet<Class> resolvedInterfaces = new HashSet<Class>();
        for (currentTargetClass = originalTargetClass; currentTargetClass != null; currentTargetClass = currentTargetClass.getSuperclass()) {
            ArrayList targetInterfaces = new ArrayList(Arrays.asList(currentTargetClass.getInterfaces()));
            while (!targetInterfaces.isEmpty()) {
                PainlessClass targetPainlessClass2;
                Class targetInterface = (Class)targetInterfaces.remove(0);
                if (!resolvedInterfaces.add(targetInterface) || (targetPainlessClass2 = this.classesToPainlessClasses.get(targetInterface)) == null) continue;
                T painlessObject2 = objectLookup.apply(targetPainlessClass2);
                if (painlessObject2 != null) {
                    return painlessObject2;
                }
                targetInterfaces.addAll(Arrays.asList(targetInterface.getInterfaces()));
            }
        }
        return null;
    }
}

