/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FilterIterator;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public final class FieldSubsetReader
extends SequentialStoredFieldsLeafReader {
    private final FieldInfos fieldInfos;
    private final CharacterRunAutomaton filter;
    private final Terms fieldNamesFilterTerms;

    public static DirectoryReader wrap(DirectoryReader in, CharacterRunAutomaton filter) throws IOException {
        return new FieldSubsetDirectoryReader(in, filter);
    }

    FieldSubsetReader(LeafReader in, CharacterRunAutomaton filter) throws IOException {
        super(in);
        ArrayList<FieldInfo> filteredInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fi : in.getFieldInfos()) {
            if (!filter.run(fi.name)) continue;
            filteredInfos.add(fi);
        }
        this.fieldInfos = new FieldInfos(filteredInfos.toArray(new FieldInfo[filteredInfos.size()]));
        this.filter = filter;
        Terms fieldNameTerms = super.terms("_field_names");
        this.fieldNamesFilterTerms = fieldNameTerms == null ? null : new FieldNamesTerms(fieldNameTerms);
    }

    boolean hasField(String field) {
        return this.fieldInfos.fieldInfo(field) != null;
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public Fields getTermVectors(int docID) throws IOException {
        Object f = super.getTermVectors(docID);
        if (f == null) {
            return null;
        }
        return (f = new FieldFilterFields((Fields)f)).iterator().hasNext() ? f : null;
    }

    static Map<String, Object> filter(Map<String, ?> map, CharacterRunAutomaton includeAutomaton, int initialState) {
        HashMap<String, Object> filtered = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            List<Object> filteredValue;
            String key = entry.getKey();
            int state = FieldSubsetReader.step(includeAutomaton, key, initialState);
            if (state == -1) continue;
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map mapValue;
                if ((state = includeAutomaton.step(state, 46)) == -1 || (filteredValue = FieldSubsetReader.filter(mapValue = (Map)value, includeAutomaton, state)).isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                Iterable iterableValue = (Iterable)value;
                filteredValue = FieldSubsetReader.filter(iterableValue, includeAutomaton, state);
                if (filteredValue.isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (!includeAutomaton.isAccept(state)) continue;
            filtered.put(key, value);
        }
        return filtered;
    }

    private static List<Object> filter(Iterable<?> iterable, CharacterRunAutomaton includeAutomaton, int initialState) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        for (Object value : iterable) {
            if (value instanceof Map) {
                int state = includeAutomaton.step(initialState, 46);
                if (state == -1) continue;
                Map<String, Object> filteredValue = FieldSubsetReader.filter((Map)value, includeAutomaton, state);
                filtered.add(filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                List<Object> filteredValue = FieldSubsetReader.filter((Iterable)value, includeAutomaton, initialState);
                if (filteredValue.isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (!includeAutomaton.isAccept(initialState)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, (int)key.charAt(i));
        }
        return state;
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        super.document(docID, (StoredFieldVisitor)new FieldSubsetStoredFieldVisitor(visitor));
    }

    protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
        return new FieldSubsetStoredFieldsReader(reader);
    }

    public Terms terms(String field) throws IOException {
        return this.wrapTerms(super.terms(field), field);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getNumericDocValues(field) : null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getBinaryDocValues(field) : null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedDocValues(field) : null;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedNumericDocValues(field) : null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedSetDocValues(field) : null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return this.hasField(field) ? super.getNormValues(field) : null;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private Terms wrapTerms(Terms terms, String field) throws IOException {
        if (!this.hasField(field)) {
            return null;
        }
        if ("_field_names".equals(field)) {
            return this.fieldNamesFilterTerms;
        }
        return terms;
    }

    public PointValues getPointValues(String fieldName) throws IOException {
        if (this.hasField(fieldName)) {
            return super.getPointValues(fieldName);
        }
        return null;
    }

    static class FieldSubsetDirectoryReader
    extends FilterDirectoryReader {
        private final CharacterRunAutomaton filter;

        FieldSubsetDirectoryReader(DirectoryReader in, final CharacterRunAutomaton filter) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    try {
                        return new FieldSubsetReader(reader, filter);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
            this.filter = filter;
            FieldSubsetDirectoryReader.verifyNoOtherFieldSubsetDirectoryReaderIsWrapped(in);
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new FieldSubsetDirectoryReader(in, this.filter);
        }

        CharacterRunAutomaton getFilter() {
            return this.filter;
        }

        private static void verifyNoOtherFieldSubsetDirectoryReaderIsWrapped(DirectoryReader reader) {
            if (reader instanceof FilterDirectoryReader) {
                FilterDirectoryReader filterDirectoryReader = (FilterDirectoryReader)reader;
                if (filterDirectoryReader instanceof FieldSubsetDirectoryReader) {
                    throw new IllegalArgumentException(LoggerMessageFormat.format((String)"Can't wrap [{}] twice", (Object[])new Object[]{FieldSubsetDirectoryReader.class}));
                }
                FieldSubsetDirectoryReader.verifyNoOtherFieldSubsetDirectoryReaderIsWrapped(filterDirectoryReader.getDelegate());
            }
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    class FieldNamesTerms
    extends FilterLeafReader.FilterTerms {
        final long size;
        final long sumDocFreq;
        final long sumTotalFreq;

        FieldNamesTerms(Terms in) throws IOException {
            super(in);
            assert (!in.hasFreqs());
            TermsEnum e = this.iterator();
            long size = 0L;
            long sumDocFreq = 0L;
            long sumTotalFreq = 0L;
            while (e.next() != null) {
                ++size;
                sumDocFreq += (long)e.docFreq();
                sumTotalFreq += e.totalTermFreq();
            }
            this.size = size;
            this.sumDocFreq = sumDocFreq;
            this.sumTotalFreq = sumTotalFreq;
        }

        public TermsEnum iterator() throws IOException {
            return new FieldNamesTermsEnum(this.in.iterator());
        }

        public long size() throws IOException {
            return this.size;
        }

        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        public long getSumTotalTermFreq() throws IOException {
            return this.sumTotalFreq;
        }

        public int getDocCount() throws IOException {
            return FieldSubsetReader.this.maxDoc();
        }
    }

    class FieldFilterFields
    extends FilterLeafReader.FilterFields {
        FieldFilterFields(Fields in) {
            super(in);
        }

        public int size() {
            return -1;
        }

        public Iterator<String> iterator() {
            return new FilterIterator<String, String>(super.iterator()){

                protected boolean predicateFunction(String field) {
                    return FieldSubsetReader.this.hasField(field);
                }
            };
        }

        public Terms terms(String field) throws IOException {
            return FieldSubsetReader.this.wrapTerms(super.terms(field), field);
        }
    }

    class FieldSubsetStoredFieldVisitor
    extends StoredFieldVisitor {
        final StoredFieldVisitor visitor;

        FieldSubsetStoredFieldVisitor(StoredFieldVisitor visitor) {
            this.visitor = visitor;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            if ("_source".equals(fieldInfo.name)) {
                BytesArray bytes = new BytesArray(value);
                Tuple result = XContentHelper.convertToMap((BytesReference)bytes, (boolean)true);
                Map<String, Object> transformedSource = FieldSubsetReader.filter((Map)result.v2(), FieldSubsetReader.this.filter, 0);
                XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)((XContentType)result.v1()).xContent()).map(transformedSource);
                this.visitor.binaryField(fieldInfo, BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)xContentBuilder)));
            } else {
                this.visitor.binaryField(fieldInfo, value);
            }
        }

        public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.visitor.stringField(fieldInfo, value);
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.visitor.intField(fieldInfo, value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.visitor.longField(fieldInfo, value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.visitor.floatField(fieldInfo, value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.visitor.doubleField(fieldInfo, value);
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return FieldSubsetReader.this.hasField(fieldInfo.name) ? this.visitor.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
        }
    }

    class FieldSubsetStoredFieldsReader
    extends StoredFieldsReader {
        final StoredFieldsReader reader;

        FieldSubsetStoredFieldsReader(StoredFieldsReader reader) {
            this.reader = reader;
        }

        public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
            this.reader.visitDocument(docID, (StoredFieldVisitor)new FieldSubsetStoredFieldVisitor(visitor));
        }

        public StoredFieldsReader clone() {
            return new FieldSubsetStoredFieldsReader(this.reader.clone());
        }

        public StoredFieldsReader getMergeInstance() {
            return new FieldSubsetStoredFieldsReader(this.reader.getMergeInstance());
        }

        public void checkIntegrity() throws IOException {
            this.reader.checkIntegrity();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public long ramBytesUsed() {
            return this.reader.ramBytesUsed();
        }
    }

    class FieldNamesTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        FieldNamesTermsEnum(TermsEnum in) {
            super(in);
        }

        boolean accept(BytesRef term) {
            return FieldSubsetReader.this.hasField(term.utf8ToString());
        }

        public boolean seekExact(BytesRef term) throws IOException {
            return this.accept(term) && this.in.seekExact(term);
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
            TermsEnum.SeekStatus status = this.in.seekCeil(term);
            if (status == TermsEnum.SeekStatus.END || this.accept(this.term())) {
                return status;
            }
            return this.next() == null ? TermsEnum.SeekStatus.END : TermsEnum.SeekStatus.NOT_FOUND;
        }

        public BytesRef next() throws IOException {
            BytesRef next;
            while ((next = this.in.next()) != null && !this.accept(next)) {
            }
            return next;
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

