/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.ResolvedIndices;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;

public interface AuthorizationEngine {
    public void resolveAuthorizationInfo(RequestInfo var1, ActionListener<AuthorizationInfo> var2);

    public void authorizeRunAs(RequestInfo var1, AuthorizationInfo var2, ActionListener<AuthorizationResult> var3);

    public void authorizeClusterAction(RequestInfo var1, AuthorizationInfo var2, ActionListener<AuthorizationResult> var3);

    public void authorizeIndexAction(RequestInfo var1, AuthorizationInfo var2, AsyncSupplier<ResolvedIndices> var3, Map<String, IndexAbstraction> var4, ActionListener<IndexAuthorizationResult> var5);

    public void loadAuthorizedIndices(RequestInfo var1, AuthorizationInfo var2, Map<String, IndexAbstraction> var3, ActionListener<Set<String>> var4);

    public void validateIndexPermissionsAreSubset(RequestInfo var1, AuthorizationInfo var2, Map<String, List<String>> var3, ActionListener<AuthorizationResult> var4);

    public void checkPrivileges(Authentication var1, AuthorizationInfo var2, HasPrivilegesRequest var3, Collection<ApplicationPrivilegeDescriptor> var4, ActionListener<HasPrivilegesResponse> var5);

    public void getUserPrivileges(Authentication var1, AuthorizationInfo var2, GetUserPrivilegesRequest var3, ActionListener<GetUserPrivilegesResponse> var4);

    @FunctionalInterface
    public static interface AsyncSupplier<V> {
        public void getAsync(ActionListener<V> var1);
    }

    public static final class AuthorizationContext {
        private final String action;
        private final AuthorizationInfo authorizationInfo;
        private final IndicesAccessControl indicesAccessControl;

        public AuthorizationContext(String action, AuthorizationInfo authorizationInfo, IndicesAccessControl accessControl) {
            this.action = action;
            this.authorizationInfo = authorizationInfo;
            this.indicesAccessControl = accessControl;
        }

        public String getAction() {
            return this.action;
        }

        public AuthorizationInfo getAuthorizationInfo() {
            return this.authorizationInfo;
        }

        public IndicesAccessControl getIndicesAccessControl() {
            return this.indicesAccessControl;
        }
    }

    public static class IndexAuthorizationResult
    extends AuthorizationResult {
        private final IndicesAccessControl indicesAccessControl;

        public IndexAuthorizationResult(boolean auditable, IndicesAccessControl indicesAccessControl) {
            super(indicesAccessControl == null || indicesAccessControl.isGranted(), auditable);
            this.indicesAccessControl = indicesAccessControl;
        }

        @Override
        public String getFailureContext() {
            if (this.isGranted()) {
                return null;
            }
            return IndexAuthorizationResult.getFailureDescription(this.indicesAccessControl.getDeniedIndices());
        }

        public static String getFailureDescription(Collection<?> deniedIndices) {
            if (deniedIndices.isEmpty()) {
                return null;
            }
            return "on indices [" + Strings.collectionToCommaDelimitedString(deniedIndices) + "]";
        }

        public IndicesAccessControl getIndicesAccessControl() {
            return this.indicesAccessControl;
        }
    }

    public static class AuthorizationResult {
        private final boolean granted;
        private final boolean auditable;

        public AuthorizationResult(boolean granted) {
            this(granted, true);
        }

        public AuthorizationResult(boolean granted, boolean auditable) {
            this.granted = granted;
            this.auditable = auditable;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public boolean isAuditable() {
            return this.auditable;
        }

        @Nullable
        public String getFailureContext() {
            return null;
        }

        public static AuthorizationResult granted() {
            return new AuthorizationResult(true);
        }

        public static AuthorizationResult deny() {
            return new AuthorizationResult(false);
        }
    }

    public static final class RequestInfo {
        private final Authentication authentication;
        private final TransportRequest request;
        private final String action;
        @Nullable
        private final AuthorizationContext originatingAuthorizationContext;

        public RequestInfo(Authentication authentication, TransportRequest request, String action, AuthorizationContext originatingContext) {
            this.authentication = Objects.requireNonNull(authentication);
            this.request = Objects.requireNonNull(request);
            this.action = Objects.requireNonNull(action);
            this.originatingAuthorizationContext = originatingContext;
        }

        public String getAction() {
            return this.action;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public TransportRequest getRequest() {
            return this.request;
        }

        @Nullable
        public AuthorizationContext getOriginatingAuthorizationContext() {
            return this.originatingAuthorizationContext;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '{' + "authentication=[" + this.authentication + "], request=[" + this.request + "], action=[" + this.action + ']' + ", parent=[" + this.originatingAuthorizationContext + "]}";
        }
    }

    public static final class EmptyAuthorizationInfo
    implements AuthorizationInfo {
        public static final EmptyAuthorizationInfo INSTANCE = new EmptyAuthorizationInfo();

        private EmptyAuthorizationInfo() {
        }

        @Override
        public Map<String, Object> asMap() {
            return Collections.emptyMap();
        }
    }

    public static interface AuthorizationInfo {
        public Map<String, Object> asMap();

        default public AuthorizationInfo getAuthenticatedUserAuthorizationInfo() {
            return this;
        }
    }
}

