/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rest.action;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageRequestBuilder;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestXPackUsageAction
extends XPackRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_xpack/usage"));
    }

    public String getName() {
        return "xpack_usage_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) {
        assert (client.es() instanceof NodeClient) : "Expected a NodeClient";
        TimeValue masterTimeout = request.paramAsTime("master_timeout", MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT);
        HttpChannel httpChannel = request.getHttpChannel();
        return channel -> ((XPackUsageRequestBuilder)new XPackUsageRequestBuilder((ElasticsearchClient)new RestCancellableNodeClient((NodeClient)client.es(), httpChannel)).setMasterNodeTimeout(masterTimeout)).execute((ActionListener)new RestBuilderListener<XPackUsageResponse>(channel){

            public RestResponse buildResponse(XPackUsageResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (XPackFeatureSet.Usage usage : response.getUsages()) {
                    builder.field(usage.name(), (ToXContent)usage);
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

