/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.ToCharFormatter;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class DateTimeFormatProcessor
extends BinaryDateTimeProcessor {
    public static final String NAME = "dtformat";
    private static final String[][] JAVA_TIME_FORMAT_REPLACEMENTS = new String[][]{{"tt", "a"}, {"t", "a"}, {"dddd", "eeee"}, {"ddd", "eee"}, {"K", "V"}, {"g", "G"}, {"f", "S"}, {"F", "S"}, {"z", "X"}};
    private final Formatter formatter;

    public DateTimeFormatProcessor(Processor source1, Processor source2, ZoneId zoneId, Formatter formatter) {
        super(source1, source2, zoneId);
        this.formatter = formatter;
    }

    public DateTimeFormatProcessor(StreamInput in) throws IOException {
        super(in);
        this.formatter = (Formatter)in.readEnum(Formatter.class);
    }

    @Override
    protected void doWrite(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.formatter);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object timestamp, Object pattern) {
        return this.formatter.format(timestamp, pattern, this.zoneId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.formatter});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DateTimeFormatProcessor other = (DateTimeFormatProcessor)((Object)obj);
        return super.equals((Object)other) && Objects.equals((Object)this.formatter, (Object)other.formatter);
    }

    public Formatter formatter() {
        return this.formatter;
    }

    public static enum Formatter {
        FORMAT{

            @Override
            protected Function<TemporalAccessor, String> formatterFor(String pattern) {
                if (pattern.isEmpty()) {
                    return null;
                }
                for (String[] replacement : JAVA_TIME_FORMAT_REPLACEMENTS) {
                    pattern = pattern.replace(replacement[0], replacement[1]);
                }
                String javaPattern = pattern;
                return DateTimeFormatter.ofPattern(javaPattern, Locale.ROOT)::format;
            }
        }
        ,
        DATE_TIME_FORMAT{

            @Override
            protected Function<TemporalAccessor, String> formatterFor(String pattern) {
                return DateTimeFormatter.ofPattern(pattern, Locale.ROOT)::format;
            }
        }
        ,
        TO_CHAR{

            @Override
            protected Function<TemporalAccessor, String> formatterFor(String pattern) {
                return ToCharFormatter.ofPattern(pattern);
            }
        };


        protected abstract Function<TemporalAccessor, String> formatterFor(String var1);

        public Object format(Object timestamp, Object pattern, ZoneId zoneId) {
            if (timestamp == null || pattern == null) {
                return null;
            }
            if (!(pattern instanceof String)) {
                throw new SqlIllegalArgumentException("A string is required; received [{}]", pattern);
            }
            String patternString = (String)pattern;
            if (patternString.isEmpty()) {
                return null;
            }
            if (!(timestamp instanceof ZonedDateTime) && !(timestamp instanceof OffsetTime)) {
                throw new SqlIllegalArgumentException("A date/datetime/time is required; received [{}]", timestamp);
            }
            Comparable<ChronoZonedDateTime<?>> ta = timestamp instanceof ZonedDateTime ? ((ZonedDateTime)timestamp).withZoneSameInstant(zoneId) : DateUtils.asTimeAtZone((OffsetTime)timestamp, zoneId);
            try {
                return this.formatterFor(patternString).apply((TemporalAccessor)((Object)ta));
            }
            catch (IllegalArgumentException | DateTimeException e) {
                throw new SqlIllegalArgumentException("Invalid pattern [{}] is received for formatting date/time [{}]; {}", pattern, timestamp, e.getMessage());
            }
        }
    }
}

