/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.xpack.ql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.ql.tree.Source;

public class TermQuery
extends LeafQuery {
    private final String term;
    private final Object value;
    private final boolean caseInsensitive;

    public TermQuery(Source source, String term, Object value) {
        this(source, term, value, false);
    }

    public TermQuery(Source source, String term, Object value, boolean caseInsensitive) {
        super(source);
        this.term = term;
        this.value = value;
        this.caseInsensitive = caseInsensitive;
    }

    public String term() {
        return this.term;
    }

    public Object value() {
        return this.value;
    }

    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public QueryBuilder asBuilder() {
        TermQueryBuilder qb = QueryBuilders.termQuery(this.term, this.value);
        return !this.caseInsensitive ? qb : qb.caseInsensitive(this.caseInsensitive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.term, this.value, this.caseInsensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermQuery other = (TermQuery)obj;
        return Objects.equals(this.term, other.term) && Objects.equals(this.value, other.value) && Objects.equals(this.caseInsensitive, other.caseInsensitive);
    }

    @Override
    protected String innerToString() {
        return this.term + ":" + this.value;
    }
}

