/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.tree.Source;

public class NotQuery
extends Query {
    private final Query child;

    public NotQuery(Source source, Query child) {
        super(source);
        if (child == null) {
            throw new IllegalArgumentException("child is required");
        }
        this.child = child;
    }

    public Query child() {
        return this.child;
    }

    @Override
    public boolean containsNestedField(String path, String field) {
        return this.child.containsNestedField(path, field);
    }

    @Override
    public Query addNestedField(String path, String field, String format, boolean hasDocValues) {
        Query rewrittenChild = this.child.addNestedField(path, field, format, hasDocValues);
        if (this.child == rewrittenChild) {
            return this;
        }
        return new NotQuery(this.source(), this.child);
    }

    @Override
    public void enrichNestedSort(NestedSortBuilder sort) {
        this.child.enrichNestedSort(sort);
    }

    @Override
    public QueryBuilder asBuilder() {
        return QueryBuilders.boolQuery().mustNot(this.child.asBuilder());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.child.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NotQuery other = (NotQuery)obj;
        return this.child.equals(other.child);
    }

    @Override
    protected String innerToString() {
        return this.child.toString();
    }
}

