/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackSettings;

public final class TLSLicenseBootstrapCheck
implements BootstrapCheck {
    @Override
    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        License license;
        if (!XPackSettings.TRANSPORT_SSL_ENABLED.get(context.settings()).booleanValue() && XPackLicenseState.isTransportTlsRequired(license = LicenseService.getLicense(context.metadata()), context.settings())) {
            return BootstrapCheck.BootstrapCheckResult.failure("Transport SSL must be enabled if security is enabled on a [" + license.operationMode().description() + "] license. Please set [xpack.security.transport.ssl.enabled] to [true] or disable security by setting [xpack.security.enabled] to [false]");
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }
}

