/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.RollupField;

public abstract class RollupActionDateHistogramGroupConfig
implements Writeable,
ToXContentObject {
    static final String NAME = "date_histogram";
    public static final String FIXED_INTERVAL = "fixed_interval";
    public static final String CALENDAR_INTERVAL = "calendar_interval";
    public static final String TIME_ZONE = "time_zone";
    public static final String DEFAULT_TIMEZONE = "UTC";
    private static final String FIELD = "field";
    private static final ConstructingObjectParser<RollupActionDateHistogramGroupConfig, Void> PARSER = new ConstructingObjectParser("date_histogram", a -> {
        DateHistogramInterval calendarInterval = (DateHistogramInterval)a[1];
        DateHistogramInterval fixedInterval = (DateHistogramInterval)a[2];
        if (calendarInterval != null && fixedInterval == null) {
            return new CalendarInterval((String)a[0], calendarInterval, (String)a[3]);
        }
        if (calendarInterval == null && fixedInterval != null) {
            return new FixedInterval((String)a[0], fixedInterval, (String)a[3]);
        }
        if (calendarInterval != null && fixedInterval != null) {
            throw new IllegalArgumentException("Cannot set both [fixed_interval] and [calendar_interval] at the same time");
        }
        throw new IllegalArgumentException("An interval is required.  Use [fixed_interval] or [calendar_interval].");
    });
    private final String field;
    private final DateHistogramInterval interval;
    private final String timeZone;

    protected RollupActionDateHistogramGroupConfig(String field, DateHistogramInterval interval) {
        this(field, interval, null);
    }

    protected RollupActionDateHistogramGroupConfig(String field, DateHistogramInterval interval, @Nullable String timeZone) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("Field must be a non-null, non-empty string");
        }
        if (interval == null) {
            throw new IllegalArgumentException("Interval must be non-null");
        }
        this.interval = interval;
        this.field = field;
        this.timeZone = timeZone != null && !timeZone.isEmpty() ? timeZone : DEFAULT_TIMEZONE;
        RollupActionDateHistogramGroupConfig.createRounding(this.interval.toString(), this.timeZone);
    }

    public static RollupActionDateHistogramGroupConfig readFrom(StreamInput in) throws IOException {
        String type = in.readString();
        String field = in.readString();
        DateHistogramInterval interval = new DateHistogramInterval(in);
        String timeZone = in.readString();
        if (CALENDAR_INTERVAL.equals(type)) {
            return new CalendarInterval(field, interval, timeZone);
        }
        if (FIXED_INTERVAL.equals(type)) {
            return new FixedInterval(field, interval, timeZone);
        }
        throw new IllegalStateException("invalid type [" + type + "]");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getIntervalTypeName());
        out.writeString(this.field);
        this.interval.writeTo(out);
        out.writeString(this.timeZone);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(this.getIntervalTypeName(), this.interval.toString());
        builder.field(FIELD, this.field);
        builder.field(TIME_ZONE, this.timeZone);
        return builder.endObject();
    }

    public String getField() {
        return this.field;
    }

    public DateHistogramInterval getInterval() {
        return this.interval;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Rounding.Prepared createRounding() {
        return RollupActionDateHistogramGroupConfig.createRounding(this.interval.toString(), this.timeZone);
    }

    public abstract String getIntervalTypeName();

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Map<String, FieldCapabilities> fieldCaps = fieldCapsResponse.get(this.field);
        if (fieldCaps != null && !fieldCaps.isEmpty()) {
            boolean matchesDateType = false;
            for (String dateType : RollupField.DATE_FIELD_MAPPER_TYPES) {
                if (!fieldCaps.containsKey(dateType) || fieldCaps.size() != 1) continue;
                matchesDateType |= true;
                if (fieldCaps.get(dateType).isAggregatable()) {
                    return;
                }
                validationException.addValidationError("The field [" + this.field + "] must be aggregatable, but is not.");
            }
            if (!matchesDateType) {
                validationException.addValidationError("The field referenced by a date_histo group must be one of type [" + Strings.collectionToCommaDelimitedString(RollupField.DATE_FIELD_MAPPER_TYPES) + "]. Found: " + fieldCaps.keySet().toString() + " for field [" + this.field + "]");
            }
        } else {
            validationException.addValidationError("Could not find one of [" + Strings.collectionToCommaDelimitedString(RollupField.DATE_FIELD_MAPPER_TYPES) + "] fields with name [" + this.field + "].");
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof RollupActionDateHistogramGroupConfig)) {
            return false;
        }
        RollupActionDateHistogramGroupConfig that = (RollupActionDateHistogramGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.field, that.field) && ZoneId.of(this.timeZone, ZoneId.SHORT_IDS).getRules().equals(ZoneId.of(that.timeZone, ZoneId.SHORT_IDS).getRules());
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.field, ZoneId.of(this.timeZone));
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static RollupActionDateHistogramGroupConfig fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private static Rounding.Prepared createRounding(String expr, String timeZone) {
        Rounding.DateTimeUnit timeUnit = DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(expr);
        Rounding.Builder rounding = timeUnit != null ? new Rounding.Builder(timeUnit) : new Rounding.Builder(TimeValue.parseTimeValue(expr, "createRounding"));
        rounding.timeZone(ZoneId.of(timeZone, ZoneId.SHORT_IDS));
        return rounding.build().prepareForUnknown();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(CALENDAR_INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(FIXED_INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TIME_ZONE, new String[0]));
    }

    public static class FixedInterval
    extends RollupActionDateHistogramGroupConfig {
        private static final String TYPE_NAME = "fixed_interval";

        public FixedInterval(String field, DateHistogramInterval interval) {
            this(field, interval, null);
        }

        public FixedInterval(String field, DateHistogramInterval interval, String timeZone) {
            super(field, interval, timeZone);
            TimeValue.parseTimeValue(interval.toString(), "date_histogram.FixedInterval");
        }

        @Override
        public String getIntervalTypeName() {
            return "fixed_interval";
        }
    }

    public static class CalendarInterval
    extends RollupActionDateHistogramGroupConfig {
        private static final String TYPE_NAME = "calendar_interval";

        public CalendarInterval(String field, DateHistogramInterval interval) {
            this(field, interval, null);
        }

        public CalendarInterval(String field, DateHistogramInterval interval, String timeZone) {
            super(field, interval, timeZone);
            if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) == null) {
                throw new IllegalArgumentException("The supplied interval [" + interval + "] could not be parsed as a calendar interval.");
            }
        }

        @Override
        public String getIntervalTypeName() {
            return "calendar_interval";
        }
    }
}

