/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractLongScriptFieldQuery;

public class LongScriptFieldRangeQuery
extends AbstractLongScriptFieldQuery {
    private final long lowerValue;
    private final long upperValue;

    public LongScriptFieldRangeQuery(Script script, Function<LeafReaderContext, AbstractLongFieldScript> leafFactory, String fieldName, long lowerValue, long upperValue) {
        super(script, leafFactory, fieldName);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        assert (lowerValue <= upperValue);
    }

    @Override
    protected boolean matches(long[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (this.lowerValue > values[i] || values[i] > this.upperValue) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().contentEquals(field)) {
            b.append(this.fieldName()).append(':');
        }
        b.append('[').append(this.lowerValue).append(" TO ").append(this.upperValue).append(']');
        return b.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lowerValue, this.upperValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LongScriptFieldRangeQuery other = (LongScriptFieldRangeQuery)obj;
        return this.lowerValue == other.lowerValue && this.upperValue == other.upperValue;
    }

    long lowerValue() {
        return this.lowerValue;
    }

    long upperValue() {
        return this.upperValue;
    }
}

