/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.Strings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.xpack.ml.process.logging.CppLogMessageHandler;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class ProcessPipes {
    public static final String LOG_PIPE_ARG = "--logPipe=";
    public static final String COMMAND_PIPE_ARG = "--commandPipe=";
    public static final String INPUT_ARG = "--input=";
    public static final String INPUT_IS_PIPE_ARG = "--inputIsPipe";
    public static final String OUTPUT_ARG = "--output=";
    public static final String OUTPUT_IS_PIPE_ARG = "--outputIsPipe";
    public static final String RESTORE_ARG = "--restore=";
    public static final String RESTORE_IS_PIPE_ARG = "--restoreIsPipe";
    public static final String PERSIST_ARG = "--persist=";
    public static final String PERSIST_IS_PIPE_ARG = "--persistIsPipe";
    public static final String TIMEOUT_ARG = "--namedPipeConnectTimeout=";
    private final NamedPipeHelper namedPipeHelper;
    private final String jobId;
    private final String logPipeName;
    private final String commandPipeName;
    private final String processInPipeName;
    private final String processOutPipeName;
    private final String restorePipeName;
    private final String persistPipeName;
    private final Duration timeout;
    private CppLogMessageHandler logStreamHandler;
    private OutputStream commandStream;
    private OutputStream processInStream;
    private InputStream processOutStream;
    private OutputStream restoreStream;
    private InputStream persistStream;

    public ProcessPipes(Environment env, NamedPipeHelper namedPipeHelper, Duration timeout, String processName, String jobId, Long uniqueId, boolean wantCommandPipe, boolean wantProcessInPipe, boolean wantProcessOutPipe, boolean wantRestorePipe, boolean wantPersistPipe) {
        this.namedPipeHelper = namedPipeHelper;
        this.jobId = jobId;
        this.timeout = timeout;
        StringBuilder prefixBuilder = new StringBuilder();
        prefixBuilder.append(namedPipeHelper.getDefaultPipeDirectoryPrefix(env)).append(Objects.requireNonNull(processName)).append('_');
        if (!Strings.isNullOrEmpty((String)jobId)) {
            prefixBuilder.append(jobId).append('_');
        }
        if (uniqueId != null) {
            prefixBuilder.append(uniqueId).append('_');
        }
        String prefix = prefixBuilder.toString();
        String suffix = String.format(Locale.ROOT, "_%d", JvmInfo.jvmInfo().getPid());
        this.logPipeName = String.format(Locale.ROOT, "%slog%s", prefix, suffix);
        this.commandPipeName = wantCommandPipe ? String.format(Locale.ROOT, "%scommand%s", prefix, suffix) : null;
        this.processInPipeName = wantProcessInPipe ? String.format(Locale.ROOT, "%sinput%s", prefix, suffix) : null;
        this.processOutPipeName = wantProcessOutPipe ? String.format(Locale.ROOT, "%soutput%s", prefix, suffix) : null;
        this.restorePipeName = wantRestorePipe ? String.format(Locale.ROOT, "%srestore%s", prefix, suffix) : null;
        this.persistPipeName = wantPersistPipe ? String.format(Locale.ROOT, "%spersist%s", prefix, suffix) : null;
    }

    public void addArgs(List<String> command) {
        command.add(LOG_PIPE_ARG + this.logPipeName);
        if (this.commandPipeName != null) {
            command.add(COMMAND_PIPE_ARG + this.commandPipeName);
        }
        if (this.processInPipeName != null) {
            command.add(INPUT_ARG + this.processInPipeName);
            command.add(INPUT_IS_PIPE_ARG);
        }
        if (this.processOutPipeName != null) {
            command.add(OUTPUT_ARG + this.processOutPipeName);
            command.add(OUTPUT_IS_PIPE_ARG);
        }
        if (this.restorePipeName != null) {
            command.add(RESTORE_ARG + this.restorePipeName);
            command.add(RESTORE_IS_PIPE_ARG);
        }
        if (this.persistPipeName != null) {
            command.add(PERSIST_ARG + this.persistPipeName);
            command.add(PERSIST_IS_PIPE_ARG);
        }
        command.add(TIMEOUT_ARG + this.timeout.getSeconds());
    }

    public void connectLogStream() throws IOException {
        this.logStreamHandler = new CppLogMessageHandler(this.jobId, this.namedPipeHelper.openNamedPipeInputStream(this.logPipeName, this.timeout));
    }

    public void connectOtherStreams() throws IOException {
        assert (this.logStreamHandler != null) : "Must connect log stream before other streams";
        if (this.logStreamHandler == null) {
            throw new NullPointerException("Must connect log stream before other streams");
        }
        try {
            if (this.commandPipeName != null) {
                this.commandStream = this.namedPipeHelper.openNamedPipeOutputStream(this.commandPipeName, this.timeout);
            }
            if (this.processInPipeName != null) {
                this.processInStream = this.namedPipeHelper.openNamedPipeOutputStream(this.processInPipeName, this.timeout);
            }
            if (this.processOutPipeName != null) {
                this.processOutStream = this.namedPipeHelper.openNamedPipeInputStream(this.processOutPipeName, this.timeout);
            }
            if (this.restorePipeName != null) {
                this.restoreStream = this.namedPipeHelper.openNamedPipeOutputStream(this.restorePipeName, this.timeout);
            }
            if (this.persistPipeName != null) {
                this.persistStream = this.namedPipeHelper.openNamedPipeInputStream(this.persistPipeName, this.timeout);
            }
        }
        catch (IOException ioe) {
            try {
                this.closeUnusedStreams();
            }
            catch (IOException suppressed) {
                ioe.addSuppressed(new IOException("Error closing process pipes", suppressed));
            }
            throw ioe;
        }
    }

    private void closeUnusedStreams() throws IOException {
        if (this.logStreamHandler != null) {
            this.logStreamHandler.close();
        }
        if (this.commandStream != null) {
            this.commandStream.close();
        }
        if (this.processInStream != null) {
            this.processInStream.close();
        }
        if (this.processOutStream != null) {
            this.processOutStream.close();
        }
        if (this.restoreStream != null) {
            this.restoreStream.close();
        }
        if (this.persistStream != null) {
            this.persistStream.close();
        }
    }

    public CppLogMessageHandler getLogStreamHandler() {
        if (this.logStreamHandler == null) {
            throw new IllegalStateException("process streams must be connected before use");
        }
        return this.logStreamHandler;
    }

    public Optional<OutputStream> getCommandStream() {
        if (this.commandPipeName == null) {
            return Optional.empty();
        }
        if (this.commandStream == null) {
            throw new IllegalStateException("process streams must be connected before use");
        }
        return Optional.of(this.commandStream);
    }

    public Optional<OutputStream> getProcessInStream() {
        if (this.processInPipeName == null) {
            return Optional.empty();
        }
        if (this.processInStream == null) {
            throw new IllegalStateException("process streams must be connected before use");
        }
        return Optional.of(this.processInStream);
    }

    public Optional<InputStream> getProcessOutStream() {
        if (this.processOutPipeName == null) {
            return Optional.empty();
        }
        if (this.processOutStream == null) {
            throw new IllegalStateException("process streams must be connected before use");
        }
        return Optional.of(this.processOutStream);
    }

    public Optional<OutputStream> getRestoreStream() {
        if (this.restorePipeName == null) {
            return Optional.empty();
        }
        if (this.restoreStream == null) {
            throw new IllegalStateException("process streams must be connected before use");
        }
        return Optional.of(this.restoreStream);
    }

    public Optional<InputStream> getPersistStream() {
        if (this.persistPipeName == null) {
            return Optional.empty();
        }
        if (this.persistStream == null) {
            throw new IllegalStateException("process streams must be connected before use");
        }
        return Optional.of(this.persistStream);
    }

    public Duration getTimeout() {
        return this.timeout;
    }
}

