/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.ml.job.process.normalizer.BucketInfluencerNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Level;
import org.elasticsearch.xpack.ml.job.process.normalizer.Normalizable;

public class BucketNormalizable
extends Normalizable {
    private static final List<Normalizable.ChildType> CHILD_TYPES = Arrays.asList(Normalizable.ChildType.BUCKET_INFLUENCER);
    private final Bucket bucket;

    public BucketNormalizable(Bucket bucket, String indexName) {
        super(indexName);
        this.bucket = Objects.requireNonNull(bucket);
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    @Override
    public String getId() {
        return this.bucket.getId();
    }

    @Override
    public boolean isContainerOnly() {
        return true;
    }

    @Override
    public Level getLevel() {
        return Level.ROOT;
    }

    @Override
    public String getPartitionFieldName() {
        return null;
    }

    @Override
    public String getPartitionFieldValue() {
        return null;
    }

    @Override
    public String getPersonFieldName() {
        return null;
    }

    @Override
    public String getPersonFieldValue() {
        return null;
    }

    @Override
    public String getFunctionName() {
        return null;
    }

    @Override
    public String getValueFieldName() {
        return null;
    }

    @Override
    public double getProbability() {
        throw new UnsupportedOperationException("Bucket is container only");
    }

    @Override
    public double getNormalizedScore() {
        return this.bucket.getAnomalyScore();
    }

    @Override
    public void setNormalizedScore(double normalizedScore) {
        this.bucket.setAnomalyScore(normalizedScore);
    }

    @Override
    public List<Normalizable.ChildType> getChildrenTypes() {
        return CHILD_TYPES;
    }

    @Override
    public List<Normalizable> getChildren() {
        ArrayList<Normalizable> children = new ArrayList<Normalizable>();
        for (Normalizable.ChildType type : this.getChildrenTypes()) {
            children.addAll(this.getChildren(type));
        }
        return children;
    }

    @Override
    public List<Normalizable> getChildren(Normalizable.ChildType type) {
        ArrayList<Normalizable> children = new ArrayList<Normalizable>();
        switch (type) {
            case BUCKET_INFLUENCER: {
                children.addAll(this.bucket.getBucketInfluencers().stream().map(bi -> new BucketInfluencerNormalizable((BucketInfluencer)bi, this.getOriginatingIndex())).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
            }
        }
        return children;
    }

    @Override
    public boolean setMaxChildrenScore(Normalizable.ChildType childrenType, double maxScore) {
        switch (childrenType) {
            case BUCKET_INFLUENCER: {
                double oldScore = this.bucket.getAnomalyScore();
                this.bucket.setAnomalyScore(maxScore);
                return maxScore != oldScore;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + (Object)((Object)childrenType));
    }

    @Override
    public void setParentScore(double parentScore) {
        throw new UnsupportedOperationException("Bucket has no parent");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.bucket.toXContent(builder, params);
    }
}

