/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.delayeddatacheck;

import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DatafeedDelayedDataDetector;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetector;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.NullDelayedDataDetector;

public class DelayedDataDetectorFactory {
    private static final int DEFAULT_NUMBER_OF_BUCKETS_TO_SPAN = 8;
    private static final long DEFAULT_CHECK_WINDOW_MS = 0x6DDD00L;

    public static DelayedDataDetector buildDetector(Job job, DatafeedConfig datafeedConfig, Client client, NamedXContentRegistry xContentRegistry) {
        if (datafeedConfig.getDelayedDataCheckConfig().isEnabled()) {
            long window = DelayedDataDetectorFactory.validateAndCalculateWindowLength(job.getAnalysisConfig().getBucketSpan(), datafeedConfig.getDelayedDataCheckConfig().getCheckWindow());
            long bucketSpan = job.getAnalysisConfig().getBucketSpan() == null ? 0L : job.getAnalysisConfig().getBucketSpan().millis();
            return new DatafeedDelayedDataDetector(bucketSpan, window, job.getId(), job.getDataDescription().getTimeField(), datafeedConfig.getParsedQuery(xContentRegistry), datafeedConfig.getIndices().toArray(new String[0]), datafeedConfig.getIndicesOptions(), datafeedConfig.getRuntimeMappings(), client);
        }
        return new NullDelayedDataDetector();
    }

    private static long validateAndCalculateWindowLength(TimeValue bucketSpan, TimeValue currentWindow) {
        if (bucketSpan == null) {
            return 0L;
        }
        if (currentWindow == null) {
            return Math.max(0x6DDD00L, 8L * bucketSpan.millis());
        }
        if (currentWindow.compareTo(bucketSpan) < 0) {
            throw new IllegalArgumentException(Messages.getMessage((String)"delayed_data_check_config: check_window [{0}] must be greater than the bucket_span [{1}]", (Object[])new Object[]{currentWindow.getStringRep(), bucketSpan.getStringRep()}));
        }
        if (currentWindow.millis() > bucketSpan.millis() * 10000L) {
            throw new IllegalArgumentException(Messages.getMessage((String)"delayed_data_check_config: check_window [{0}] must be less than 10,000x the bucket_span [{1}]", (Object[])new Object[]{currentWindow.getStringRep(), bucketSpan.getStringRep()}));
        }
        return currentWindow.millis();
    }

    public static class BucketWithMissingData {
        private final long missingDocumentCount;
        private final Bucket bucket;

        public static BucketWithMissingData fromMissingAndBucket(long missingDocumentCount, Bucket bucket) {
            return new BucketWithMissingData(missingDocumentCount, bucket);
        }

        private BucketWithMissingData(long missingDocumentCount, Bucket bucket) {
            this.missingDocumentCount = missingDocumentCount;
            this.bucket = bucket;
        }

        public long getTimeStamp() {
            return this.bucket.getEpoch();
        }

        public Bucket getBucket() {
            return this.bucket;
        }

        public long getMissingDocumentCount() {
            return this.missingDocumentCount;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            BucketWithMissingData that = (BucketWithMissingData)other;
            return Objects.equals(that.bucket, this.bucket) && Objects.equals(that.missingDocumentCount, this.missingDocumentCount);
        }

        public int hashCode() {
            return Objects.hash(this.bucket, this.missingDocumentCount);
        }
    }
}

