/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.ml.datafeed.DatafeedRunner;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class InvalidLicenseEnforcer
implements LicenseStateListener {
    private static final Logger logger = LogManager.getLogger(InvalidLicenseEnforcer.class);
    private final ThreadPool threadPool;
    private final XPackLicenseState licenseState;
    private final DatafeedRunner datafeedRunner;
    private final AutodetectProcessManager autodetectProcessManager;
    private volatile boolean licenseStateListenerRegistered;

    InvalidLicenseEnforcer(XPackLicenseState licenseState, ThreadPool threadPool, DatafeedRunner datafeedRunner, AutodetectProcessManager autodetectProcessManager) {
        this.threadPool = threadPool;
        this.licenseState = licenseState;
        this.datafeedRunner = datafeedRunner;
        this.autodetectProcessManager = autodetectProcessManager;
    }

    void listenForLicenseStateChanges() {
        assert (!this.licenseStateListenerRegistered);
        this.licenseState.addListener((LicenseStateListener)this);
        this.licenseStateListenerRegistered = true;
    }

    public void licenseStateChanged() {
        assert (this.licenseStateListenerRegistered);
        if (!MachineLearningField.ML_API_FEATURE.checkWithoutTracking(this.licenseState)) {
            this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    logger.warn("cannot close all jobs", (Throwable)e);
                }

                protected void doRun() throws Exception {
                    InvalidLicenseEnforcer.this.datafeedRunner.stopAllDatafeedsOnThisNode("invalid license");
                    InvalidLicenseEnforcer.this.autodetectProcessManager.closeAllJobsOnThisNode("invalid license");
                }
            });
        }
    }
}

