/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public class RegisteredDomainProcessor
extends AbstractProcessor {
    private static final PublicSuffixMatcher SUFFIX_MATCHER = PublicSuffixMatcherLoader.getDefault();
    public static final String TYPE = "registered_domain";
    private final String field;
    private final String targetField;
    private final boolean ignoreMissing;

    RegisteredDomainProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public boolean getIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        DomainInfo info = this.getRegisteredDomain(ingestDocument);
        if (info == null) {
            if (this.ignoreMissing) {
                return ingestDocument;
            }
            throw new IllegalArgumentException("unable to set domain information for document");
        }
        String fieldPrefix = this.targetField;
        if (!fieldPrefix.equals("")) {
            fieldPrefix = fieldPrefix + ".";
        }
        String domainTarget = fieldPrefix + "domain";
        String registeredDomainTarget = fieldPrefix + TYPE;
        String subdomainTarget = fieldPrefix + "subdomain";
        String topLevelDomainTarget = fieldPrefix + "top_level_domain";
        if (info.getDomain() != null) {
            ingestDocument.setFieldValue(domainTarget, (Object)info.getDomain());
        }
        if (info.getRegisteredDomain() != null) {
            ingestDocument.setFieldValue(registeredDomainTarget, (Object)info.getRegisteredDomain());
        }
        if (info.getETLD() != null) {
            ingestDocument.setFieldValue(topLevelDomainTarget, (Object)info.getETLD());
        }
        if (info.getSubdomain() != null) {
            ingestDocument.setFieldValue(subdomainTarget, (Object)info.getSubdomain());
        }
        return ingestDocument;
    }

    private DomainInfo getRegisteredDomain(IngestDocument d) {
        String fieldString = (String)d.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (fieldString == null) {
            return null;
        }
        String registeredDomain = SUFFIX_MATCHER.getDomainRoot(fieldString);
        if (registeredDomain == null) {
            if (SUFFIX_MATCHER.matches(fieldString)) {
                return new DomainInfo(fieldString);
            }
            return null;
        }
        if (registeredDomain.indexOf(".") == -1) {
            return null;
        }
        return new DomainInfo(registeredDomain, fieldString);
    }

    public String getType() {
        return TYPE;
    }

    private class DomainInfo {
        private final String domain;
        private final String registeredDomain;
        private final String eTLD;
        private final String subdomain;

        private DomainInfo(String eTLD) {
            this.domain = eTLD;
            this.eTLD = eTLD;
            this.registeredDomain = null;
            this.subdomain = null;
        }

        private DomainInfo(String registeredDomain, String domain) {
            int index = registeredDomain.indexOf(".") + 1;
            if (index > 0 && index < registeredDomain.length()) {
                this.domain = domain;
                this.eTLD = registeredDomain.substring(index);
                this.registeredDomain = registeredDomain;
                int subdomainIndex = domain.lastIndexOf("." + registeredDomain);
                this.subdomain = subdomainIndex > 0 ? domain.substring(0, subdomainIndex) : null;
            } else {
                this.domain = null;
                this.eTLD = null;
                this.registeredDomain = null;
                this.subdomain = null;
            }
        }

        public String getDomain() {
            return this.domain;
        }

        public String getSubdomain() {
            return this.subdomain;
        }

        public String getRegisteredDomain() {
            return this.registeredDomain;
        }

        public String getETLD() {
            return this.eTLD;
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final String DEFAULT_TARGET_FIELD = "";

        public RegisteredDomainProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)RegisteredDomainProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)RegisteredDomainProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)DEFAULT_TARGET_FIELD);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RegisteredDomainProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)true);
            return new RegisteredDomainProcessor(processorTag, description, field, targetField, ignoreMissing);
        }
    }
}

