/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.client;

import java.util.Map;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchResponse;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsResponse;

public class WatcherClient {
    private final Client client;

    public WatcherClient(Client client) {
        this.client = client;
    }

    public GetWatchRequestBuilder prepareGetWatch(String id) {
        return new GetWatchRequestBuilder((ElasticsearchClient)this.client, id);
    }

    public GetWatchRequestBuilder prepareGetWatch() {
        return new GetWatchRequestBuilder((ElasticsearchClient)this.client);
    }

    public void getWatch(GetWatchRequest request, ActionListener<GetWatchResponse> listener) {
        this.client.execute((ActionType)GetWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<GetWatchResponse> getWatch(GetWatchRequest request) {
        return this.client.execute((ActionType)GetWatchAction.INSTANCE, (ActionRequest)request);
    }

    public DeleteWatchRequestBuilder prepareDeleteWatch(String id) {
        return new DeleteWatchRequestBuilder((ElasticsearchClient)this.client, id);
    }

    public DeleteWatchRequestBuilder prepareDeleteWatch() {
        return new DeleteWatchRequestBuilder((ElasticsearchClient)this.client);
    }

    public void deleteWatch(DeleteWatchRequest request, ActionListener<DeleteWatchResponse> listener) {
        this.client.execute((ActionType)DeleteWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<DeleteWatchResponse> deleteWatch(DeleteWatchRequest request) {
        return this.client.execute((ActionType)DeleteWatchAction.INSTANCE, (ActionRequest)request);
    }

    public PutWatchRequestBuilder preparePutWatch(String id) {
        return new PutWatchRequestBuilder((ElasticsearchClient)this.client, id);
    }

    public PutWatchRequestBuilder preparePutWatch() {
        return new PutWatchRequestBuilder((ElasticsearchClient)this.client);
    }

    public void putWatch(PutWatchRequest request, ActionListener<PutWatchResponse> listener) {
        this.client.execute((ActionType)PutWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<PutWatchResponse> putWatch(PutWatchRequest request) {
        return this.client.execute((ActionType)PutWatchAction.INSTANCE, (ActionRequest)request);
    }

    public ActionFuture<WatcherStatsResponse> watcherStats(WatcherStatsRequest request) {
        return this.client.execute((ActionType)WatcherStatsAction.INSTANCE, (ActionRequest)request);
    }

    public WatcherStatsRequestBuilder prepareWatcherStats() {
        return new WatcherStatsRequestBuilder((ElasticsearchClient)this.client);
    }

    public void watcherStats(WatcherStatsRequest request, ActionListener<WatcherStatsResponse> listener) {
        this.client.execute((ActionType)WatcherStatsAction.INSTANCE, (ActionRequest)request, listener);
    }

    public AckWatchRequestBuilder prepareAckWatch(String id) {
        return new AckWatchRequestBuilder((ElasticsearchClient)this.client, id);
    }

    public void ackWatch(AckWatchRequest request, ActionListener<AckWatchResponse> listener) {
        this.client.execute((ActionType)AckWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AckWatchResponse> ackWatch(AckWatchRequest request) {
        return this.client.execute((ActionType)AckWatchAction.INSTANCE, (ActionRequest)request);
    }

    public ActivateWatchRequestBuilder prepareActivateWatch(String id, boolean activate) {
        return new ActivateWatchRequestBuilder((ElasticsearchClient)this.client, id, activate);
    }

    public void activateWatch(ActivateWatchRequest request, ActionListener<ActivateWatchResponse> listener) {
        this.client.execute((ActionType)ActivateWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ActivateWatchResponse> activateWatch(ActivateWatchRequest request) {
        return this.client.execute((ActionType)ActivateWatchAction.INSTANCE, (ActionRequest)request);
    }

    public WatcherServiceRequestBuilder prepareWatchService() {
        return new WatcherServiceRequestBuilder((ElasticsearchClient)this.client);
    }

    public void watcherService(WatcherServiceRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)WatcherServiceAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> watcherService(WatcherServiceRequest request) {
        return this.client.execute((ActionType)WatcherServiceAction.INSTANCE, (ActionRequest)request);
    }

    public ExecuteWatchRequestBuilder prepareExecuteWatch(String id) {
        return new ExecuteWatchRequestBuilder((ElasticsearchClient)this.client, id);
    }

    public ExecuteWatchRequestBuilder prepareExecuteWatch() {
        return new ExecuteWatchRequestBuilder((ElasticsearchClient)this.client);
    }

    public void executeWatch(ExecuteWatchRequest request, ActionListener<ExecuteWatchResponse> listener) {
        this.client.execute((ActionType)ExecuteWatchAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ExecuteWatchResponse> executeWatch(ExecuteWatchRequest request) {
        return this.client.execute((ActionType)ExecuteWatchAction.INSTANCE, (ActionRequest)request);
    }

    public WatcherClient filterWithHeader(Map<String, String> headers) {
        return new WatcherClient(this.client.filterWithHeader(headers));
    }
}

