/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.DataTierMigrationRoutedStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;

public class MigrateAction
implements LifecycleAction {
    public static final String NAME = "migrate";
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    private static final Logger logger = LogManager.getLogger(MigrateAction.class);
    static final String CONDITIONAL_SKIP_MIGRATE_STEP = "branch-check-skip-action";
    private static final ConstructingObjectParser<MigrateAction, Void> PARSER = new ConstructingObjectParser("migrate", a -> new MigrateAction(a[0] == null ? true : (Boolean)a[0]));
    private final boolean enabled;

    public static MigrateAction parse(XContentParser parser) {
        return (MigrateAction)PARSER.apply(parser, null);
    }

    public MigrateAction() {
        this(true);
    }

    public MigrateAction(boolean enabled) {
        this.enabled = enabled;
    }

    public MigrateAction(StreamInput in) throws IOException {
        this(in.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.enabled);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        if (this.enabled) {
            Step.StepKey preMigrateBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_SKIP_MIGRATE_STEP);
            Step.StepKey migrationKey = new Step.StepKey(phase, NAME, NAME);
            Step.StepKey migrationRoutedKey = new Step.StepKey(phase, NAME, "check-migration");
            String targetTier = "data_" + phase;
            assert (DataTier.validTierName((String)targetTier)) : "invalid data tier name:" + targetTier;
            BranchingStep conditionalSkipActionStep = new BranchingStep(preMigrateBranchingKey, migrationKey, nextStepKey, (index, clusterState) -> {
                Settings indexSettings = clusterState.metadata().index(index).getSettings();
                if (SearchableSnapshotsSettings.isPartialSearchableSnapshotIndex((Settings)indexSettings)) {
                    String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexSettings);
                    logger.debug("[{}] action in policy [{}] is configured for index [{}] which is a partially mounted index. skipping this action", (Object)NAME, (Object)policyName, (Object)index.getName());
                    return true;
                }
                return false;
            });
            UpdateSettingsStep updateMigrationSettingStep = new UpdateSettingsStep(migrationKey, migrationRoutedKey, client, DataTier.getPreferredTiersConfigurationSettings((String)targetTier));
            DataTierMigrationRoutedStep migrationRoutedStep = new DataTierMigrationRoutedStep(migrationRoutedKey, nextStepKey);
            return org.elasticsearch.core.List.of((Object[])new Step[]{conditionalSkipActionStep, updateMigrationSettingStep, migrationRoutedStep});
        }
        return org.elasticsearch.core.List.of();
    }

    public int hashCode() {
        return Objects.hash(this.enabled);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MigrateAction other = (MigrateAction)obj;
        return Objects.equals(this.enabled, other.enabled);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
    }
}

