/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.fulltext;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.FullTextUtils;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class FullTextPredicate
extends Expression {
    private final String query;
    private final String options;
    private final Map<String, String> optionMap;
    private final String analyzer;

    FullTextPredicate(Source source, String query, String options, List<Expression> children) {
        super(source, children);
        this.query = query;
        this.options = options;
        this.optionMap = FullTextUtils.parseSettings(options, source);
        this.analyzer = this.optionMap.get("analyzer");
    }

    public String query() {
        return this.query;
    }

    public String options() {
        return this.options;
    }

    public Map<String, String> optionMap() {
        return this.optionMap;
    }

    public String analyzer() {
        return this.analyzer;
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FullTextPredicate other = (FullTextPredicate)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.options, other.options);
    }

    public static enum Operator {
        AND,
        OR;


        public org.elasticsearch.index.query.Operator toEs() {
            return org.elasticsearch.index.query.Operator.fromString((String)this.name());
        }
    }
}

