/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ql.async.QlStatusResponse;
import org.elasticsearch.xpack.sql.action.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.SqlVersion;
import org.elasticsearch.xpack.sql.proto.StringUtils;

public class SqlQueryResponse
extends ActionResponse
implements ToXContentObject,
QlStatusResponse.AsyncStatus {
    private String cursor;
    private Mode mode;
    private SqlVersion sqlVersion;
    private boolean columnar;
    private List<ColumnInfo> columns;
    private List<List<Object>> rows;
    private static final String INTERVAL_CLASS_NAME = "Interval";
    @Nullable
    private final String asyncExecutionId;
    private final boolean isPartial;
    private final boolean isRunning;

    public SqlQueryResponse(StreamInput in) throws IOException {
        super(in);
        this.cursor = in.readString();
        if (in.readBoolean()) {
            int columnCount = in.readVInt();
            ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>(columnCount);
            for (int c = 0; c < columnCount; ++c) {
                columns.add(SqlQueryResponse.readColumnInfo(in));
            }
            this.columns = Collections.unmodifiableList(columns);
        } else {
            this.columns = null;
        }
        int rowCount = in.readVInt();
        ArrayList rows = new ArrayList(rowCount);
        if (rowCount > 0) {
            int columnCount = in.readVInt();
            for (int r = 0; r < rowCount; ++r) {
                ArrayList<Object> row = new ArrayList<Object>(columnCount);
                for (int c = 0; c < columnCount; ++c) {
                    row.add(in.readGenericValue());
                }
                rows.add(Collections.unmodifiableList(row));
            }
        }
        this.rows = Collections.unmodifiableList(rows);
        if (in.getVersion().onOrAfter(Version.V_7_14_0)) {
            this.columnar = in.readBoolean();
            this.asyncExecutionId = in.readOptionalString();
            this.isPartial = in.readBoolean();
            this.isRunning = in.readBoolean();
        } else {
            this.asyncExecutionId = null;
            this.isPartial = false;
            this.isRunning = false;
        }
    }

    public SqlQueryResponse(String cursor, Mode mode, SqlVersion sqlVersion, boolean columnar, @Nullable List<ColumnInfo> columns, List<List<Object>> rows, @Nullable String asyncExecutionId, boolean isPartial, boolean isRunning) {
        this.cursor = cursor;
        this.mode = mode;
        this.sqlVersion = sqlVersion != null ? sqlVersion : SqlVersion.fromId(Version.CURRENT.id);
        this.columnar = columnar;
        this.columns = columns;
        this.rows = rows;
        this.asyncExecutionId = asyncExecutionId;
        this.isPartial = isPartial;
        this.isRunning = isRunning;
    }

    public SqlQueryResponse(String cursor, Mode mode, SqlVersion sqlVersion, boolean columnar, @Nullable List<ColumnInfo> columns, List<List<Object>> rows) {
        this(cursor, mode, sqlVersion, columnar, columns, rows, null, false, false);
    }

    public String cursor() {
        return this.cursor;
    }

    public boolean hasCursor() {
        return !"".equals(this.cursor);
    }

    public long size() {
        return this.rows.size();
    }

    public List<ColumnInfo> columns() {
        return this.columns;
    }

    public boolean columnar() {
        return this.columnar;
    }

    public List<List<Object>> rows() {
        return this.rows;
    }

    public SqlQueryResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public SqlQueryResponse columns(List<ColumnInfo> columns) {
        this.columns = columns;
        return this;
    }

    public SqlQueryResponse rows(List<List<Object>> rows) {
        this.rows = rows;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.cursor);
        if (this.columns == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.columns.size());
            for (ColumnInfo columnInfo : this.columns) {
                SqlQueryResponse.writeColumnInfo(out, columnInfo);
            }
        }
        out.writeVInt(this.rows.size());
        if (this.rows.size() > 0) {
            out.writeVInt(this.rows.get(0).size());
            for (List list : this.rows) {
                for (Object value : list) {
                    out.writeGenericValue(value);
                }
            }
        }
        out.writeBoolean(this.columnar);
        out.writeOptionalString(this.asyncExecutionId);
        out.writeBoolean(this.isPartial);
        out.writeBoolean(this.isRunning);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.hasId()) {
            builder.field("id", this.asyncExecutionId);
            builder.field("is_partial", this.isPartial);
            builder.field("is_running", this.isRunning);
        }
        if (this.columns != null) {
            builder.startArray("columns");
            for (ColumnInfo columnInfo : this.columns) {
                columnInfo.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.columnar) {
            long columnsCount;
            long l = columnsCount = this.columns != null ? (long)this.columns.size() : 0L;
            if (this.size() > 0L) {
                columnsCount = this.rows().get(0).size();
            }
            builder.startArray("values");
            int index = 0;
            while ((long)index < columnsCount) {
                builder.startArray();
                for (List<Object> row : this.rows()) {
                    SqlQueryResponse.value(builder, this.mode, this.sqlVersion, row.get(index));
                }
                builder.endArray();
                ++index;
            }
            builder.endArray();
        } else {
            builder.startArray("rows");
            for (List list : this.rows()) {
                builder.startArray();
                for (Object value : list) {
                    SqlQueryResponse.value(builder, this.mode, this.sqlVersion, value);
                }
                builder.endArray();
            }
            builder.endArray();
        }
        if (!this.cursor.equals("")) {
            builder.field(AbstractSqlQueryRequest.CURSOR.getPreferredName(), this.cursor);
        }
        return builder.endObject();
    }

    public static XContentBuilder value(XContentBuilder builder, Mode mode, SqlVersion sqlVersion, Object value) throws IOException {
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)value;
            if (mode == Mode.JDBC && SqlVersion.isClientCompatible(SqlVersion.fromId(Version.CURRENT.id), sqlVersion)) {
                builder.value(StringUtils.toString(zdt, sqlVersion));
            } else {
                builder.value(StringUtils.toString(zdt));
            }
        } else if (mode == Mode.CLI && value != null && value.getClass().getSuperclass().getSimpleName().equals(INTERVAL_CLASS_NAME)) {
            builder.value(value.toString());
        } else {
            builder.value(value);
        }
        return builder;
    }

    public static ColumnInfo readColumnInfo(StreamInput in) throws IOException {
        String table = in.readString();
        String name = in.readString();
        String esType = in.readString();
        Integer displaySize = in.readOptionalVInt();
        return new ColumnInfo(table, name, esType, displaySize);
    }

    public static void writeColumnInfo(StreamOutput out, ColumnInfo columnInfo) throws IOException {
        out.writeString(columnInfo.table());
        out.writeString(columnInfo.name());
        out.writeString(columnInfo.esType());
        out.writeOptionalVInt(columnInfo.displaySize());
    }

    public boolean hasId() {
        return Strings.hasText(this.asyncExecutionId);
    }

    @Override
    public String id() {
        return this.asyncExecutionId;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlQueryResponse that = (SqlQueryResponse)o;
        return Objects.equals(this.cursor, that.cursor) && Objects.equals(this.columns, that.columns) && Objects.equals(this.rows, that.rows);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.columns, this.rows);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

