/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;

public class InvalidMappedField
extends EsField {
    private final String errorMessage;

    public InvalidMappedField(String name, String errorMessage) {
        super(name, DataTypes.UNSUPPORTED, Collections.emptyMap(), false);
        this.errorMessage = errorMessage;
    }

    public InvalidMappedField(String name) {
        super(name, DataTypes.UNSUPPORTED, Collections.emptyMap(), false);
        this.errorMessage = "";
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.errorMessage);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            InvalidMappedField other = (InvalidMappedField)obj;
            return Objects.equals(this.errorMessage, other.errorMessage);
        }
        return false;
    }

    @Override
    public EsField getExactField() {
        throw new QlIllegalArgumentException("Field [" + this.getName() + "] is invalid, cannot access it");
    }

    @Override
    public EsField.Exact getExactInfo() {
        return new EsField.Exact(false, "Field [" + this.getName() + "] is invalid, cannot access it");
    }
}

