/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.rolemapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authc.support.mapper.TemplateRoleName;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public class PutRoleMappingRequest
extends ActionRequest
implements WriteRequest<PutRoleMappingRequest> {
    private String name = null;
    private boolean enabled = true;
    private List<String> roles = Collections.emptyList();
    private List<TemplateRoleName> roleTemplates = Collections.emptyList();
    private RoleMapperExpression rules = null;
    private Map<String, Object> metadata = Collections.emptyMap();
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;

    public PutRoleMappingRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.enabled = in.readBoolean();
        this.roles = in.readStringList();
        if (in.getVersion().onOrAfter(Version.V_7_2_0)) {
            this.roleTemplates = in.readList(TemplateRoleName::new);
        }
        this.rules = ExpressionParser.readExpression(in);
        this.metadata = in.readMap();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
    }

    public PutRoleMappingRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("role-mapping name is missing", validationException);
        }
        if (this.roles.isEmpty() && this.roleTemplates.isEmpty()) {
            validationException = ValidateActions.addValidationError("role-mapping roles or role-templates are missing", validationException);
        }
        if (this.roles.size() > 0 && this.roleTemplates.size() > 0) {
            validationException = ValidateActions.addValidationError("role-mapping cannot have both roles and role-templates", validationException);
        }
        if (this.rules == null) {
            validationException = ValidateActions.addValidationError("role-mapping rules are missing", validationException);
        }
        if (MetadataUtils.containsReservedMetadata(this.metadata)) {
            validationException = ValidateActions.addValidationError("metadata keys may not start with [_]", validationException);
        }
        return validationException;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public List<TemplateRoleName> getRoleTemplates() {
        return Collections.unmodifiableList(this.roleTemplates);
    }

    public void setRoles(List<String> roles) {
        this.roles = new ArrayList<String>(roles);
    }

    public void setRoleTemplates(List<TemplateRoleName> templates) {
        this.roleTemplates = new ArrayList<TemplateRoleName>(templates);
    }

    public RoleMapperExpression getRules() {
        return this.rules;
    }

    public void setRules(RoleMapperExpression expression) {
        this.rules = expression;
    }

    @Override
    public PutRoleMappingRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = Objects.requireNonNull(metadata);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeBoolean(this.enabled);
        out.writeStringCollection(this.roles);
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeList(this.roleTemplates);
        }
        ExpressionParser.writeExpression(this.rules, out);
        out.writeMap(this.metadata);
        this.refreshPolicy.writeTo(out);
    }

    public ExpressionRoleMapping getMapping() {
        return new ExpressionRoleMapping(this.name, this.rules, this.roles, this.roleTemplates, this.metadata, this.enabled);
    }
}

