/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class HistogramGroupConfig
implements Writeable,
ToXContentObject {
    public static final String NAME = "histogram";
    public static final String INTERVAL = "interval";
    private static final String FIELDS = "fields";
    private static final ConstructingObjectParser<HistogramGroupConfig, Void> PARSER = new ConstructingObjectParser("histogram", args -> {
        List fields = (List)args[1];
        return new HistogramGroupConfig((Long)args[0], fields != null ? fields.toArray(new String[fields.size()]) : null);
    });
    private final long interval;
    private final String[] fields;

    public HistogramGroupConfig(long interval, String ... fields) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("Interval must be a positive long");
        }
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("Fields must have at least one value");
        }
        this.interval = interval;
        this.fields = fields;
    }

    public HistogramGroupConfig(StreamInput in) throws IOException {
        this.interval = in.readVLong();
        this.fields = in.readStringArray();
    }

    public long getInterval() {
        return this.interval;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Arrays.stream(this.fields).forEach(field -> {
            Map fieldCaps = (Map)fieldCapsResponse.get(field);
            if (fieldCaps != null && !fieldCaps.isEmpty()) {
                fieldCaps.forEach((key, value) -> {
                    if (RollupField.NUMERIC_FIELD_MAPPER_TYPES.contains(key)) {
                        if (!value.isAggregatable()) {
                            validationException.addValidationError("The field [" + field + "] must be aggregatable across all indices, but is not.");
                        }
                    } else {
                        validationException.addValidationError("The field referenced by a histo group must be a [numeric] type, but found " + fieldCaps.keySet().toString() + " for field [" + field + "]");
                    }
                });
            } else {
                validationException.addValidationError("Could not find a [numeric] field with name [" + field + "] in any of the indices matching the index pattern.");
            }
        });
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INTERVAL, this.interval);
        builder.field(FIELDS, this.fields);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.interval);
        out.writeStringArray(this.fields);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HistogramGroupConfig that = (HistogramGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.interval, Arrays.hashCode(this.fields));
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static HistogramGroupConfig fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(INTERVAL, new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField(FIELDS, new String[0]));
    }
}

