/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public final class AnomalyDetectorsIndex {
    private static final String RESULTS_MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    private static final String RESOURCE_PATH = "/org/elasticsearch/xpack/core/ml/anomalydetection/";

    private AnomalyDetectorsIndex() {
    }

    public static String jobResultsIndexPrefix() {
        return ".ml-anomalies-";
    }

    public static String jobResultsAliasedName(String jobId) {
        return ".ml-anomalies-" + jobId;
    }

    public static String resultsWriteAlias(String jobId) {
        return ".ml-anomalies-.write-" + jobId;
    }

    public static String jobStateIndexWriteAlias() {
        return ".ml-state-write";
    }

    public static String jobStateIndexPattern() {
        return ".ml-state*";
    }

    public static void createStateIndexAndAliasIfNecessary(Client client, ClusterState state, IndexNameExpressionResolver resolver, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, state, resolver, ".ml-state", AnomalyDetectorsIndex.jobStateIndexWriteAlias(), masterNodeTimeout, finalListener);
    }

    public static void createStateIndexAndAliasIfNecessaryAndWaitForYellow(Client client, ClusterState state, IndexNameExpressionResolver resolver, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener<Boolean> stateIndexAndAliasCreated = ActionListener.wrap(success -> {
            ClusterHealthRequest request = (ClusterHealthRequest)Requests.clusterHealthRequest(AnomalyDetectorsIndex.jobStateIndexWriteAlias()).waitForYellowStatus().masterNodeTimeout(masterNodeTimeout);
            ClientHelper.executeAsyncWithOrigin(client, "ml", ClusterHealthAction.INSTANCE, request, ActionListener.wrap(r -> finalListener.onResponse(!r.isTimedOut()), finalListener::onFailure));
        }, finalListener::onFailure);
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, state, resolver, ".ml-state", AnomalyDetectorsIndex.jobStateIndexWriteAlias(), masterNodeTimeout, stateIndexAndAliasCreated);
    }

    public static String wrappedResultsMapping() {
        return "{\n\"_doc\" : " + AnomalyDetectorsIndex.resultsMapping() + "\n}";
    }

    public static String wrappedResultsMapping(String mappingType) {
        return "{\n\"" + mappingType + "\" : " + AnomalyDetectorsIndex.resultsMapping() + "\n}";
    }

    public static String resultsMapping() {
        return TemplateUtils.loadTemplate("/org/elasticsearch/xpack/core/ml/anomalydetection/results_index_mappings.json", Version.CURRENT.toString(), RESULTS_MAPPINGS_VERSION_VARIABLE);
    }
}

