/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Hyperparameters
implements ToXContentObject,
Writeable {
    private static final String NAME = "hyperparameters";
    public static final ParseField HYPERPARAMETER_NAME = new ParseField("name", new String[0]);
    public static final ParseField VALUE = new ParseField("value", new String[0]);
    public static final ParseField ABSOLUTE_IMPORTANCE = new ParseField("absolute_importance", new String[0]);
    public static final ParseField RELATIVE_IMPORTANCE = new ParseField("relative_importance", new String[0]);
    public static final ParseField SUPPLIED = new ParseField("supplied", new String[0]);
    public static final ConstructingObjectParser<Hyperparameters, Void> LENIENT_PARSER = Hyperparameters.createParser(true);
    public static final ConstructingObjectParser<Hyperparameters, Void> STRICT_PARSER = Hyperparameters.createParser(false);
    public final String hyperparameterName;
    public final double value;
    public final Double absoluteImportance;
    public final Double relativeImportance;
    public final boolean supplied;

    private static ConstructingObjectParser<Hyperparameters, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<Hyperparameters, Void> parser = new ConstructingObjectParser<Hyperparameters, Void>(NAME, ignoreUnknownFields, a -> new Hyperparameters((String)a[0], (Double)a[1], (Double)a[2], (Double)a[3], (Boolean)a[4]));
        parser.declareString(ConstructingObjectParser.constructorArg(), HYPERPARAMETER_NAME);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), VALUE);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ABSOLUTE_IMPORTANCE);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), RELATIVE_IMPORTANCE);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), SUPPLIED);
        return parser;
    }

    public static Hyperparameters fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? LENIENT_PARSER.parse(parser, null) : STRICT_PARSER.parse(parser, null);
    }

    public Hyperparameters(StreamInput in) throws IOException {
        this.hyperparameterName = in.readString();
        this.value = in.readDouble();
        this.supplied = in.readBoolean();
        this.absoluteImportance = in.readOptionalDouble();
        this.relativeImportance = in.readOptionalDouble();
    }

    Hyperparameters(String hyperparameterName, double value, Double absoluteImportance, Double relativeImportance, boolean supplied) {
        this.hyperparameterName = hyperparameterName;
        this.value = value;
        this.supplied = supplied;
        this.absoluteImportance = absoluteImportance;
        this.relativeImportance = relativeImportance;
        if (!this.supplied) {
            ExceptionsHelper.requireNonNull(absoluteImportance, ABSOLUTE_IMPORTANCE.getPreferredName());
            ExceptionsHelper.requireNonNull(relativeImportance, RELATIVE_IMPORTANCE.getPreferredName());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.hyperparameterName);
        out.writeDouble(this.value);
        out.writeBoolean(this.supplied);
        out.writeOptionalDouble(this.absoluteImportance);
        out.writeOptionalDouble(this.relativeImportance);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.asMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hyperparameters that = (Hyperparameters)o;
        return Objects.equals(that.hyperparameterName, this.hyperparameterName) && Objects.equals(this.value, that.value) && Objects.equals(this.absoluteImportance, that.absoluteImportance) && Objects.equals(this.relativeImportance, that.relativeImportance) && Objects.equals(this.supplied, that.supplied);
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(HYPERPARAMETER_NAME.getPreferredName(), this.hyperparameterName);
        map.put(VALUE.getPreferredName(), this.value);
        if (this.absoluteImportance != null) {
            map.put(ABSOLUTE_IMPORTANCE.getPreferredName(), this.absoluteImportance);
        }
        if (this.relativeImportance != null) {
            map.put(RELATIVE_IMPORTANCE.getPreferredName(), this.relativeImportance);
        }
        map.put(SUPPLIED.getPreferredName(), this.supplied);
        return map;
    }

    public int hashCode() {
        return Objects.hash(this.hyperparameterName, this.value, this.absoluteImportance, this.relativeImportance, this.supplied);
    }
}

