/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.protocol.xpack.license.GetLicenseRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestGetLicenseAction
extends XPackRestHandler {
    RestGetLicenseAction() {
    }

    @Override
    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of(RestHandler.Route.builder(RestRequest.Method.GET, "/_license").replaces(RestRequest.Method.GET, URI_BASE + "/license", RestApiVersion.V_7).build());
    }

    @Override
    public String getName() {
        return "get_license";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(final RestRequest request, XPackClient client) throws IOException {
        boolean hideEnterprise = !request.paramAsBoolean("accept_enterprise", false);
        int licenseVersion = hideEnterprise ? 4 : 5;
        HashMap<String, String> overrideParams = new HashMap<String, String>(3);
        overrideParams.put("rest_view", "true");
        overrideParams.put("license_version", String.valueOf(licenseVersion));
        overrideParams.put("hide_enterprise", String.valueOf(hideEnterprise));
        final ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(overrideParams, request);
        GetLicenseRequest getLicenseRequest = new GetLicenseRequest();
        getLicenseRequest.local(request.paramAsBoolean("local", getLicenseRequest.local()));
        return channel -> client.es().admin().cluster().execute(GetLicenseAction.INSTANCE, getLicenseRequest, new RestBuilderListener<GetLicenseResponse>(channel){

            @Override
            public RestResponse buildResponse(GetLicenseResponse response, XContentBuilder builder) throws Exception {
                if (!request.hasParam("pretty")) {
                    builder.prettyPrint().lfAtEnd();
                }
                boolean hasLicense = response.license() != null;
                builder.startObject();
                if (hasLicense) {
                    builder.startObject("license");
                    response.license().toInnerXContent(builder, params);
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(hasLicense ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }
        });
    }
}

