/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AddAuditLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogException;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteAuditLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyAuditLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNAuditLogMessage;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AuditLogReader
implements Closeable {
    private final BufferedReader reader;

    public AuditLogReader(String path) throws IOException {
        this.reader = new BufferedReader(new FileReader(path));
    }

    public AuditLogReader(File file) throws IOException {
        this.reader = new BufferedReader(new FileReader(file));
    }

    public AuditLogReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public AuditLogReader(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public AuditLogMessage read() throws IOException, AuditLogException {
        LDIFChangeRecord changeRecord;
        String line;
        ArrayList<String> fullMessageLines = new ArrayList<String>(20);
        ArrayList<String> nonCommentLines = new ArrayList<String>(20);
        while ((line = this.reader.readLine()) != null) {
            if (line.isEmpty()) {
                if (!nonCommentLines.isEmpty()) break;
                fullMessageLines.clear();
                continue;
            }
            fullMessageLines.add(line);
            if (line.startsWith("#")) continue;
            nonCommentLines.add(line);
        }
        if (nonCommentLines.isEmpty()) {
            return null;
        }
        try {
            String[] ldifLines = StaticUtils.toArray(nonCommentLines, String.class);
            changeRecord = LDIFReader.decodeChangeRecord(ldifLines);
        }
        catch (Exception e) {
            Debug.debugException(e);
            String concatenatedLogLines = StaticUtils.concatenateStrings("[ ", "\"", ", ", "\"", " ]", fullMessageLines);
            throw new AuditLogException(fullMessageLines, LogMessages.ERR_AUDIT_LOG_READER_CANNOT_PARSE_CHANGE_RECORD.get(concatenatedLogLines, StaticUtils.getExceptionMessage(e)), e);
        }
        if (changeRecord instanceof LDIFAddChangeRecord) {
            return new AddAuditLogMessage(fullMessageLines, (LDIFAddChangeRecord)changeRecord);
        }
        if (changeRecord instanceof LDIFDeleteChangeRecord) {
            return new DeleteAuditLogMessage(fullMessageLines, (LDIFDeleteChangeRecord)changeRecord);
        }
        if (changeRecord instanceof LDIFModifyChangeRecord) {
            return new ModifyAuditLogMessage(fullMessageLines, (LDIFModifyChangeRecord)changeRecord);
        }
        if (changeRecord instanceof LDIFModifyDNChangeRecord) {
            return new ModifyDNAuditLogMessage(fullMessageLines, (LDIFModifyDNChangeRecord)changeRecord);
        }
        String concatenatedLogLines = StaticUtils.concatenateStrings("[ ", "\"", ", ", "\"", " ]", fullMessageLines);
        throw new AuditLogException(fullMessageLines, LogMessages.ERR_AUDIT_LOG_READER_UNSUPPORTED_CHANGE_RECORD.get(concatenatedLogLines, changeRecord.getChangeType().getName()));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

