/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SoftDeletedEntry
extends ReadOnlyEntry {
    public static final String ATTR_SOFT_DELETE_FROM_DN = "ds-soft-delete-from-dn";
    public static final String ATTR_SOFT_DELETE_REQUESTER_DN = "ds-soft-delete-requester-dn";
    public static final String ATTR_SOFT_DELETE_REQUESTER_IP_ADDRESS = "ds-soft-delete-requester-ip-address";
    public static final String ATTR_SOFT_DELETE_TIMESTAMP = "ds-soft-delete-timestamp";
    public static final String OC_SOFT_DELETED_ENTRY = "ds-soft-delete-entry";
    private static final long serialVersionUID = -3450703461178674797L;
    private final Date softDeleteTimestamp;
    private final String softDeleteFromDN;
    private final String softDeleteRequesterDN;
    private final String softDeleteRequesterIPAddress;

    public SoftDeletedEntry(Entry entry) throws LDAPException {
        super(entry);
        if (!entry.hasObjectClass(OC_SOFT_DELETED_ENTRY)) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, UnboundIDDSMessages.ERR_SOFT_DELETED_ENTRY_MISSING_OC.get(entry.getDN()));
        }
        this.softDeleteFromDN = entry.getAttributeValue(ATTR_SOFT_DELETE_FROM_DN);
        this.softDeleteTimestamp = entry.getAttributeValueAsDate(ATTR_SOFT_DELETE_TIMESTAMP);
        this.softDeleteRequesterDN = entry.getAttributeValue(ATTR_SOFT_DELETE_REQUESTER_DN);
        this.softDeleteRequesterIPAddress = entry.getAttributeValue(ATTR_SOFT_DELETE_REQUESTER_IP_ADDRESS);
        if (this.softDeleteFromDN == null) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, UnboundIDDSMessages.ERR_SOFT_DELETED_ENTRY_MISSING_FROM_DN.get(entry.getDN()));
        }
    }

    public String getSoftDeleteFromDN() {
        return this.softDeleteFromDN;
    }

    public Date getSoftDeleteTimestamp() {
        return this.softDeleteTimestamp;
    }

    public String getSoftDeleteRequesterDN() {
        return this.softDeleteRequesterDN;
    }

    public String getSoftDeleteRequesterIPAddress() {
        return this.softDeleteRequesterIPAddress;
    }

    public ReadOnlyEntry getUndeletedEntry() {
        Entry e = this.duplicate();
        e.setDN(this.softDeleteFromDN);
        e.removeAttributeValue("objectClass", OC_SOFT_DELETED_ENTRY);
        e.removeAttribute(ATTR_SOFT_DELETE_FROM_DN);
        e.removeAttribute(ATTR_SOFT_DELETE_TIMESTAMP);
        e.removeAttribute(ATTR_SOFT_DELETE_REQUESTER_DN);
        e.removeAttribute(ATTR_SOFT_DELETE_REQUESTER_IP_ADDRESS);
        return new ReadOnlyEntry(e);
    }

    public static boolean isSoftDeletedEntry(Entry entry) {
        return entry.hasObjectClass(OC_SOFT_DELETED_ENTRY) && entry.hasAttribute(ATTR_SOFT_DELETE_FROM_DN);
    }
}

