/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.support.FilterBlobContainer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.BlobStoreCacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.CachedBlob;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ByteRange;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheFile;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.CacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheService;
import org.elasticsearch.xpack.searchablesnapshots.recovery.SearchableSnapshotRecoveryState;
import org.elasticsearch.xpack.searchablesnapshots.store.InMemoryNoOpCommitDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.input.CachedBlobContainerIndexInput;
import org.elasticsearch.xpack.searchablesnapshots.store.input.ChecksumBlobContainerIndexInput;
import org.elasticsearch.xpack.searchablesnapshots.store.input.DirectBlobContainerIndexInput;
import org.elasticsearch.xpack.searchablesnapshots.store.input.FrozenIndexInput;

public class SearchableSnapshotDirectory
extends BaseDirectory {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotDirectory.class);
    private final Supplier<BlobContainer> blobContainerSupplier;
    private final Supplier<BlobStoreIndexShardSnapshot> snapshotSupplier;
    private final BlobStoreCacheService blobStoreCacheService;
    private final String repository;
    private final SnapshotId snapshotId;
    private final IndexId indexId;
    private final ShardId shardId;
    private final LongSupplier statsCurrentTimeNanosSupplier;
    private final Map<String, IndexInputStats> stats;
    private final ThreadPool threadPool;
    private final CacheService cacheService;
    private final boolean useCache;
    private final boolean prewarmCache;
    private final Set<String> excludedFileTypes;
    private final long uncachedChunkSize;
    private final Path cacheDir;
    private final ShardPath shardPath;
    private final AtomicBoolean closed;
    private final boolean partial;
    private final FrozenCacheService frozenCacheService;
    private final ByteSizeValue blobStoreCacheMaxLength;
    private volatile BlobStoreIndexShardSnapshot snapshot;
    private volatile BlobContainer blobContainer;
    private volatile boolean loaded;
    private volatile SearchableSnapshotRecoveryState recoveryState;

    public SearchableSnapshotDirectory(Supplier<BlobContainer> blobContainer, Supplier<BlobStoreIndexShardSnapshot> snapshot, BlobStoreCacheService blobStoreCacheService, String repository, SnapshotId snapshotId, IndexId indexId, ShardId shardId, Settings indexSettings, LongSupplier currentTimeNanosSupplier, CacheService cacheService, Path cacheDir, ShardPath shardPath, ThreadPool threadPool, FrozenCacheService frozenCacheService) {
        super((LockFactory)new SingleInstanceLockFactory());
        this.snapshotSupplier = Objects.requireNonNull(snapshot);
        this.blobContainerSupplier = Objects.requireNonNull(blobContainer);
        this.blobStoreCacheService = Objects.requireNonNull(blobStoreCacheService);
        this.repository = Objects.requireNonNull(repository);
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.indexId = Objects.requireNonNull(indexId);
        this.shardId = Objects.requireNonNull(shardId);
        this.stats = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        this.statsCurrentTimeNanosSupplier = Objects.requireNonNull(currentTimeNanosSupplier);
        this.cacheService = Objects.requireNonNull(cacheService);
        this.cacheDir = Objects.requireNonNull(cacheDir);
        this.shardPath = Objects.requireNonNull(shardPath);
        this.closed = new AtomicBoolean(false);
        this.useCache = (Boolean)SearchableSnapshots.SNAPSHOT_CACHE_ENABLED_SETTING.get(indexSettings);
        this.partial = (Boolean)SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING.get(indexSettings);
        this.prewarmCache = !this.partial && this.useCache ? (Boolean)SearchableSnapshots.SNAPSHOT_CACHE_PREWARM_ENABLED_SETTING.get(indexSettings) : false;
        this.excludedFileTypes = new HashSet<String>((Collection)SearchableSnapshots.SNAPSHOT_CACHE_EXCLUDED_FILE_TYPES_SETTING.get(indexSettings));
        this.uncachedChunkSize = ((ByteSizeValue)SearchableSnapshots.SNAPSHOT_UNCACHED_CHUNK_SIZE_SETTING.get(indexSettings)).getBytes();
        this.blobStoreCacheMaxLength = (ByteSizeValue)SearchableSnapshots.SNAPSHOT_BLOB_CACHE_METADATA_FILES_MAX_LENGTH_SETTING.get(indexSettings);
        this.threadPool = threadPool;
        this.loaded = false;
        this.frozenCacheService = frozenCacheService;
        assert (this.invariant());
    }

    private synchronized boolean invariant() {
        assert (this.loaded != (this.snapshot == null));
        assert (this.loaded != (this.blobContainer == null));
        assert (this.loaded != (this.recoveryState == null));
        return true;
    }

    protected final boolean assertCurrentThreadMayLoadSnapshot() {
        String threadName = Thread.currentThread().getName();
        assert (threadName.contains("[generic]") || threadName.startsWith("TEST-")) : "current thread [" + Thread.currentThread() + "] may not load " + this.snapshotId;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSnapshot(RecoveryState snapshotRecoveryState, ActionListener<Void> preWarmListener) {
        assert (snapshotRecoveryState != null);
        assert (snapshotRecoveryState instanceof SearchableSnapshotRecoveryState);
        assert (snapshotRecoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT || snapshotRecoveryState.getRecoverySource().getType() == RecoverySource.Type.PEER) : snapshotRecoveryState.getRecoverySource().getType();
        assert (this.assertCurrentThreadMayLoadSnapshot());
        if (!(snapshotRecoveryState instanceof SearchableSnapshotRecoveryState)) {
            throw new IllegalArgumentException("A SearchableSnapshotRecoveryState instance was expected");
        }
        boolean alreadyLoaded = this.loaded;
        if (!alreadyLoaded) {
            SearchableSnapshotDirectory searchableSnapshotDirectory = this;
            synchronized (searchableSnapshotDirectory) {
                alreadyLoaded = this.loaded;
                if (!alreadyLoaded) {
                    this.blobContainer = this.blobContainerSupplier.get();
                    this.snapshot = this.snapshotSupplier.get();
                    this.loaded = true;
                    this.cleanExistingRegularShardFiles();
                    this.waitForPendingEvictions();
                    this.recoveryState = (SearchableSnapshotRecoveryState)snapshotRecoveryState;
                    this.prewarmCache(preWarmListener);
                }
            }
        }
        assert (this.invariant());
        return !alreadyLoaded;
    }

    @Nullable
    public BlobContainer blobContainer() {
        BlobContainer blobContainer = this.blobContainer;
        assert (blobContainer != null);
        return blobContainer;
    }

    @Nullable
    public BlobStoreIndexShardSnapshot snapshot() {
        BlobStoreIndexShardSnapshot snapshot = this.snapshot;
        assert (snapshot != null);
        return snapshot;
    }

    private java.util.List<BlobStoreIndexShardSnapshot.FileInfo> files() {
        if (!this.loaded) {
            return List.of();
        }
        java.util.List files = this.snapshot().indexFiles();
        assert (files != null);
        assert (files.size() > 0);
        return files;
    }

    public SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public IndexId getIndexId() {
        return this.indexId;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Map<String, IndexInputStats> getStats() {
        return Collections.unmodifiableMap(this.stats);
    }

    @Nullable
    IndexInputStats getStats(String fileName) {
        return this.stats.get(SearchableSnapshotDirectory.getNonNullFileExt(fileName));
    }

    public void clearStats() {
        this.stats.clear();
    }

    private BlobStoreIndexShardSnapshot.FileInfo fileInfo(String name) throws FileNotFoundException {
        return this.files().stream().filter(fileInfo -> fileInfo.physicalName().equals(name)).findFirst().orElseThrow(() -> new FileNotFoundException(name));
    }

    public final String[] listAll() {
        this.ensureOpen();
        return (String[])this.files().stream().map(BlobStoreIndexShardSnapshot.FileInfo::physicalName).sorted(String::compareTo).toArray(String[]::new);
    }

    public final long fileLength(String name) throws IOException {
        this.ensureOpen();
        return this.fileInfo(name).length();
    }

    public Set<String> getPendingDeletions() {
        throw SearchableSnapshotDirectory.unsupportedException();
    }

    public void sync(Collection<String> names) {
        throw SearchableSnapshotDirectory.unsupportedException();
    }

    public void syncMetaData() {
        throw SearchableSnapshotDirectory.unsupportedException();
    }

    public void deleteFile(String name) {
        throw SearchableSnapshotDirectory.unsupportedException();
    }

    public IndexOutput createOutput(String name, IOContext context) {
        throw SearchableSnapshotDirectory.unsupportedException();
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) {
        throw SearchableSnapshotDirectory.unsupportedException();
    }

    public void rename(String source, String dest) {
        throw SearchableSnapshotDirectory.unsupportedException();
    }

    private static UnsupportedOperationException unsupportedException() {
        assert (false) : "this operation is not supported and should have not be called";
        return new UnsupportedOperationException("Searchable snapshot directory does not support this operation");
    }

    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.isOpen = false;
        }
    }

    public void clearCache(boolean clearCacheService, boolean clearFrozenCacheService) {
        for (BlobStoreIndexShardSnapshot.FileInfo file : this.files()) {
            CacheKey cacheKey = this.createCacheKey(file.physicalName());
            if (clearCacheService) {
                this.cacheService.removeFromCache(cacheKey);
            }
            if (!clearFrozenCacheService) continue;
            this.frozenCacheService.removeFromCache(cacheKey);
        }
    }

    protected IndexInputStats createIndexInputStats(long numFiles, long totalSize, long minSize, long maxSize) {
        return new IndexInputStats(numFiles, totalSize, minSize, maxSize, this.statsCurrentTimeNanosSupplier);
    }

    public CacheKey createCacheKey(String fileName) {
        return new CacheKey(this.snapshotId.getUUID(), this.indexId.getName(), this.shardId, fileName);
    }

    public CacheFile getCacheFile(CacheKey cacheKey, long fileLength) throws Exception {
        return this.cacheService.get(cacheKey, fileLength, this.cacheDir);
    }

    public Executor cacheFetchAsyncExecutor() {
        return this.threadPool.executor("searchable_snapshots_cache_fetch_async");
    }

    public Executor prewarmExecutor() {
        return this.threadPool.executor("searchable_snapshots_cache_prewarming");
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        BlobStoreIndexShardSnapshot.FileInfo fileInfo = this.fileInfo(name);
        if (fileInfo.metadata().hashEqualsContents()) {
            BytesRef content = fileInfo.metadata().hash();
            return new ByteArrayIndexInput("ByteArrayIndexInput(" + name + ')', content.bytes, content.offset, content.length);
        }
        if (context == Store.READONCE_CHECKSUM) {
            return ChecksumBlobContainerIndexInput.create(fileInfo.physicalName(), fileInfo.length(), fileInfo.checksum(), context);
        }
        String ext = SearchableSnapshotDirectory.getNonNullFileExt(name);
        IndexInputStats inputStats = this.stats.computeIfAbsent(ext, n -> {
            IndexInputStats.Counter counter = new IndexInputStats.Counter();
            for (BlobStoreIndexShardSnapshot.FileInfo file : this.files()) {
                if (!ext.equals(SearchableSnapshotDirectory.getNonNullFileExt(file.physicalName()))) continue;
                counter.add(file.length());
            }
            return this.createIndexInputStats(counter.count(), counter.total(), counter.min(), counter.max());
        });
        if (this.useCache && !this.isExcludedFromCache(name)) {
            if (this.partial) {
                return new FrozenIndexInput(name, this, fileInfo, context, inputStats, this.frozenCacheService.getRangeSize(), this.frozenCacheService.getRecoveryRangeSize());
            }
            return new CachedBlobContainerIndexInput(name, this, fileInfo, context, inputStats, this.cacheService.getRangeSize(), this.cacheService.getRecoveryRangeSize());
        }
        return new DirectBlobContainerIndexInput(name, this, fileInfo, context, inputStats, this.getUncachedChunkSize(), BufferedIndexInput.bufferSize((IOContext)context));
    }

    static String getNonNullFileExt(String name) {
        String ext = IndexFileNames.getExtension((String)name);
        return ext == null ? "" : ext;
    }

    private long getUncachedChunkSize() {
        if (this.uncachedChunkSize < 0L) {
            return this.blobContainer().readBlobPreferredLength();
        }
        return this.uncachedChunkSize;
    }

    private boolean isExcludedFromCache(String name) {
        String ext = IndexFileNames.getExtension((String)name);
        return ext != null && this.excludedFileTypes.contains(ext);
    }

    public boolean isRecoveryFinalized() {
        SearchableSnapshotRecoveryState recoveryState = this.recoveryState;
        if (recoveryState == null) {
            return false;
        }
        RecoveryState.Stage stage = recoveryState.getStage();
        return stage == RecoveryState.Stage.DONE || stage == RecoveryState.Stage.FINALIZE;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(snapshotId=" + this.snapshotId + ", indexId=" + this.indexId + " shardId=" + this.shardId + ')';
    }

    private void cleanExistingRegularShardFiles() {
        try {
            IOUtils.rm((Path[])new Path[]{this.shardPath.resolveIndex(), this.shardPath.resolveTranslog()});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void waitForPendingEvictions() {
        assert (Thread.holdsLock((Object)this));
        this.cacheService.waitForCacheFilesEvictionIfNeeded(this.snapshotId.getUUID(), this.indexId.getName(), this.shardId);
    }

    private void prewarmCache(ActionListener<Void> listener) {
        if (!this.prewarmCache) {
            this.recoveryState.setPreWarmComplete();
            listener.onResponse(null);
            return;
        }
        LinkedBlockingQueue<Tuple<ActionListener<Void>, CheckedRunnable<Exception>>> queue = new LinkedBlockingQueue<Tuple<ActionListener<Void>, CheckedRunnable<Exception>>>();
        Executor executor = this.prewarmExecutor();
        GroupedActionListener completionListener = new GroupedActionListener(ActionListener.wrap(voids -> {
            this.recoveryState.setPreWarmComplete();
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)), this.snapshot().totalFileCount());
        for (BlobStoreIndexShardSnapshot.FileInfo file : this.snapshot().indexFiles()) {
            boolean hashEqualsContents = file.metadata().hashEqualsContents();
            if (hashEqualsContents || this.isExcludedFromCache(file.physicalName())) {
                if (hashEqualsContents) {
                    this.recoveryState.getIndex().addFileDetail(file.physicalName(), file.length(), true);
                } else {
                    this.recoveryState.ignoreFile(file.physicalName());
                }
                completionListener.onResponse(null);
                continue;
            }
            this.recoveryState.getIndex().addFileDetail(file.physicalName(), file.length(), false);
            boolean submitted = false;
            try {
                IndexInput input = this.openInput(file.physicalName(), CachedBlobContainerIndexInput.CACHE_WARMING_CONTEXT);
                assert (input instanceof CachedBlobContainerIndexInput) : "expected cached index input but got " + input.getClass();
                int numberOfParts = file.numberOfParts();
                StepListener fileCompletionListener = new StepListener();
                fileCompletionListener.addListener(completionListener.map(voids -> null));
                fileCompletionListener.whenComplete(voids -> {
                    logger.debug("{} file [{}] prewarmed", (Object)this.shardId, (Object)file.physicalName());
                    input.close();
                }, e -> {
                    logger.warn(() -> new ParameterizedMessage("{} prewarming failed for file [{}]", (Object)this.shardId, (Object)file.physicalName()), (Throwable)e);
                    IOUtils.closeWhileHandlingException((Closeable)input);
                });
                GroupedActionListener partsListener = new GroupedActionListener((ActionListener)fileCompletionListener, numberOfParts);
                submitted = true;
                int p = 0;
                while (p < numberOfParts) {
                    int part = p++;
                    queue.add((Tuple<ActionListener<Void>, CheckedRunnable<Exception>>)Tuple.tuple((Object)partsListener, () -> {
                        this.ensureOpen();
                        logger.trace("{} warming cache for [{}] part [{}/{}]", (Object)this.shardId, (Object)file.physicalName(), (Object)(part + 1), (Object)numberOfParts);
                        long startTimeInNanos = this.statsCurrentTimeNanosSupplier.getAsLong();
                        long persistentCacheLength = (Long)((CachedBlobContainerIndexInput)input).prefetchPart(part).v1();
                        if (persistentCacheLength == file.length()) {
                            this.recoveryState.markIndexFileAsReused(file.physicalName());
                        } else {
                            this.recoveryState.getIndex().addRecoveredBytesToFile(file.physicalName(), file.partBytes(part));
                        }
                        logger.trace(() -> new ParameterizedMessage("{} part [{}/{}] of [{}] warmed in [{}] ms", new Object[]{this.shardId, part + 1, numberOfParts, file.physicalName(), TimeValue.timeValueNanos((long)(this.statsCurrentTimeNanosSupplier.getAsLong() - startTimeInNanos)).millis()}));
                    }));
                }
            }
            catch (IOException e2) {
                logger.warn(() -> new ParameterizedMessage("{} unable to prewarm file [{}]", (Object)this.shardId, (Object)file.physicalName()), (Throwable)e2);
                if (submitted) continue;
                completionListener.onFailure((Exception)e2);
            }
        }
        logger.debug("{} warming shard cache for [{}] files", (Object)this.shardId, (Object)queue.size());
        int workers = Math.min(this.threadPool.info("searchable_snapshots_cache_prewarming").getMax(), queue.size());
        for (int i = 0; i < workers; ++i) {
            this.prewarmNext(executor, queue);
        }
    }

    private void prewarmNext(Executor executor, BlockingQueue<Tuple<ActionListener<Void>, CheckedRunnable<Exception>>> queue) {
        try {
            Tuple<ActionListener<Void>, CheckedRunnable<Exception>> next = queue.poll(0L, TimeUnit.MILLISECONDS);
            if (next == null) {
                return;
            }
            executor.execute((Runnable)ActionRunnable.run((ActionListener)ActionListener.runAfter((ActionListener)((ActionListener)next.v1()), () -> this.prewarmNext(executor, queue)), (CheckedRunnable)((CheckedRunnable)next.v2())));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn(() -> new ParameterizedMessage("{} prewarming worker has been interrupted", (Object)this.shardId), (Throwable)e);
        }
    }

    public static Directory create(RepositoriesService repositories, CacheService cache, IndexSettings indexSettings, ShardPath shardPath, LongSupplier currentTimeNanosSupplier, ThreadPool threadPool, BlobStoreCacheService blobStoreCacheService, FrozenCacheService frozenCacheService) throws IOException {
        String repositoryName;
        Repository repository;
        if (!(SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.exists(indexSettings.getSettings()) && SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.exists(indexSettings.getSettings()) && SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.exists(indexSettings.getSettings()) && SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.exists(indexSettings.getSettings()) && SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.exists(indexSettings.getSettings()))) {
            throw new IllegalArgumentException("directly setting [" + IndexModule.INDEX_STORE_TYPE_SETTING.getKey() + "] to [" + "snapshot" + "] is not permitted; use the mount snapshot API instead");
        }
        if (indexSettings.hasCustomDataPath()) {
            throw new IllegalArgumentException("setting [" + IndexMetadata.INDEX_DATA_PATH_SETTING.getKey() + "] is not permitted on searchable snapshots, but was [" + (String)IndexMetadata.INDEX_DATA_PATH_SETTING.get(indexSettings.getSettings()) + "]");
        }
        if (SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.exists(indexSettings.getSettings())) {
            repository = SearchableSnapshotDirectory.repositoryByUuid(repositories.getRepositories(), (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.get(indexSettings.getSettings()));
            repositoryName = repository.getMetadata().name();
        } else {
            repositoryName = (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.get(indexSettings.getSettings());
            repository = repositories.repository(repositoryName);
            assert (repository.getMetadata().name().equals(repositoryName)) : repository.getMetadata().name() + " vs " + repositoryName;
        }
        BlobStoreRepository blobStoreRepository = SearchableSnapshots.getSearchableRepository(repository);
        IndexId indexId = new IndexId((String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings.getSettings()));
        SnapshotId snapshotId = new SnapshotId((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings.getSettings()));
        LazyInitializable lazyBlobContainer = new LazyInitializable(() -> new RateLimitingBlobContainer(blobStoreRepository, blobStoreRepository.shardContainer(indexId, shardPath.getShardId().id())));
        LazyInitializable lazySnapshot = new LazyInitializable(() -> blobStoreRepository.loadShardSnapshot((BlobContainer)lazyBlobContainer.getOrCompute(), snapshotId));
        Path cacheDir = CacheService.getShardCachePath(shardPath).resolve(snapshotId.getUUID());
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        return new InMemoryNoOpCommitDirectory((Directory)new SearchableSnapshotDirectory(() -> ((LazyInitializable)lazyBlobContainer).getOrCompute(), () -> ((LazyInitializable)lazySnapshot).getOrCompute(), blobStoreCacheService, repositoryName, snapshotId, indexId, shardPath.getShardId(), indexSettings.getSettings(), currentTimeNanosSupplier, cache, cacheDir, shardPath, threadPool, frozenCacheService));
    }

    public static SearchableSnapshotDirectory unwrapDirectory(Directory dir) {
        while (dir != null) {
            if (dir instanceof SearchableSnapshotDirectory) {
                return (SearchableSnapshotDirectory)dir;
            }
            if (dir instanceof InMemoryNoOpCommitDirectory) {
                dir = ((InMemoryNoOpCommitDirectory)dir).getRealDirectory();
                continue;
            }
            if (dir instanceof FilterDirectory) {
                dir = ((FilterDirectory)dir).getDelegate();
                continue;
            }
            dir = null;
        }
        return null;
    }

    public ByteRange getBlobCacheByteRange(String fileName, long fileLength) {
        return this.blobStoreCacheService.computeBlobCacheByteRange(this.shardId, fileName, fileLength, this.blobStoreCacheMaxLength);
    }

    public CachedBlob getCachedBlob(String name, ByteRange range) {
        return this.blobStoreCacheService.get(this.repository, this.snapshotId, this.indexId, this.shardId, name, range);
    }

    public void putCachedBlob(String name, ByteRange range, BytesReference content, ActionListener<Void> listener) {
        this.blobStoreCacheService.putAsync(this.repository, this.snapshotId, this.indexId, this.shardId, name, range, content, this.threadPool.absoluteTimeInMillis(), listener);
    }

    public FrozenCacheService.FrozenCacheFile getFrozenCacheFile(String fileName, long length) {
        return this.frozenCacheService.getFrozenCacheFile(this.createCacheKey(fileName), length);
    }

    private static Repository repositoryByUuid(Map<String, Repository> repositories, String repositoryUuid, String originalName) {
        for (Repository repository : repositories.values()) {
            if (!repository.getMetadata().uuid().equals(repositoryUuid)) continue;
            return repository;
        }
        throw new RepositoryMissingException("uuid [" + repositoryUuid + "], original name [" + originalName + "]");
    }

    private static class RateLimitingBlobContainer
    extends FilterBlobContainer {
        private final BlobStoreRepository blobStoreRepository;

        RateLimitingBlobContainer(BlobStoreRepository blobStoreRepository, BlobContainer blobContainer) {
            super(blobContainer);
            this.blobStoreRepository = blobStoreRepository;
        }

        protected BlobContainer wrapChild(BlobContainer child) {
            return new RateLimitingBlobContainer(this.blobStoreRepository, child);
        }

        public InputStream readBlob(String blobName) throws IOException {
            return this.blobStoreRepository.maybeRateLimitRestores(super.readBlob(blobName));
        }

        public InputStream readBlob(String blobName, long position, long length) throws IOException {
            return this.blobStoreRepository.maybeRateLimitRestores(super.readBlob(blobName, position, length));
        }
    }
}

