/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.PutTransformAction;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.action.TransformConfigLinter;
import org.elasticsearch.xpack.transform.action.TransformPrivilegeChecker;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;

public class TransportPutTransformAction
extends AcknowledgedTransportMasterNodeAction<PutTransformAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportPutTransformAction.class);
    private final XPackLicenseState licenseState;
    private final Client client;
    private final TransformConfigManager transformConfigManager;
    private final SecurityContext securityContext;
    private final TransformAuditor auditor;

    @Inject
    public TransportPutTransformAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, TransformServices transformServices, Client client, IngestService ingestService) {
        this("cluster:admin/transform/put", settings, transportService, threadPool, actionFilters, indexNameExpressionResolver, clusterService, licenseState, transformServices, client, ingestService);
    }

    protected TransportPutTransformAction(String name, Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, TransformServices transformServices, Client client, IngestService ingestService) {
        super(name, transportService, clusterService, threadPool, actionFilters, PutTransformAction.Request::new, indexNameExpressionResolver, "same");
        this.licenseState = licenseState;
        this.client = client;
        this.transformConfigManager = transformServices.getConfigManager();
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.auditor = transformServices.getAuditor();
    }

    protected void masterOperation(PutTransformAction.Request request, ClusterState clusterState, ActionListener<AcknowledgedResponse> listener) throws Exception {
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        Map filteredHeaders = ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders());
        TransformConfig config = request.getConfig().setHeaders(filteredHeaders).setCreateTime(Instant.now()).setVersion(Version.CURRENT);
        String transformId = config.getId();
        if (PersistentTasksCustomMetadata.getTaskWithId((ClusterState)clusterState, (String)transformId) != null) {
            listener.onFailure((Exception)new ResourceAlreadyExistsException(TransformMessages.getMessage((String)"Transform with id [{0}] already exists", (Object[])new Object[]{transformId}), new Object[0]));
            return;
        }
        ActionListener validateTransformListener = ActionListener.wrap(validationResponse -> this.putTransform(request, listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener checkPrivilegesListener = ActionListener.wrap(aVoid -> this.client.execute((ActionType)ValidateTransformAction.INSTANCE, (ActionRequest)new ValidateTransformAction.Request(config, request.isDeferValidation(), request.timeout()), validateTransformListener), arg_0 -> listener.onFailure(arg_0));
        if (this.licenseState.isSecurityEnabled() && !request.isDeferValidation()) {
            TransformPrivilegeChecker.checkPrivileges("create", this.securityContext, this.indexNameExpressionResolver, clusterState, this.client, config, true, (ActionListener<Void>)checkPrivilegesListener);
        } else {
            checkPrivilegesListener.onResponse(null);
        }
    }

    protected ClusterBlockException checkBlock(PutTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void putTransform(PutTransformAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        TransformConfig config = request.getConfig();
        Function function = FunctionFactory.create(config);
        ActionListener putTransformConfigurationListener = ActionListener.wrap(putTransformConfigurationResult -> {
            logger.debug("[{}] created transform", (Object)config.getId());
            this.auditor.info(config.getId(), "Created transform.");
            List<String> warnings = TransformConfigLinter.getWarnings(function, config.getSource(), config.getSyncConfig());
            for (String warning : warnings) {
                logger.warn((Message)new ParameterizedMessage("[{}] {}", (Object)config.getId(), (Object)warning));
                this.auditor.warning(config.getId(), warning);
            }
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, arg_0 -> listener.onFailure(arg_0));
        this.transformConfigManager.putTransformConfiguration(config, (ActionListener<Boolean>)putTransformConfigurationListener);
    }
}

