/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ilm.action.GetLifecycleAction;

public class RestGetLifecycleAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_ilm/policy"), new RestHandler.Route(RestRequest.Method.GET, "/_ilm/policy/{name}")));
    }

    public String getName() {
        return "ilm_get_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String[] lifecycleNames = Strings.splitStringByCommaToArray((String)restRequest.param("name"));
        GetLifecycleAction.Request getLifecycleRequest = new GetLifecycleAction.Request(lifecycleNames);
        getLifecycleRequest.timeout(restRequest.paramAsTime("timeout", getLifecycleRequest.timeout()));
        getLifecycleRequest.masterNodeTimeout(restRequest.paramAsTime("master_timeout", getLifecycleRequest.masterNodeTimeout()));
        return channel -> client.execute((ActionType)GetLifecycleAction.INSTANCE, (ActionRequest)getLifecycleRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

