/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.eql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class FilterExec
extends UnaryExec
implements Unexecutable {
    private final Expression condition;
    private final boolean onAggs;

    public FilterExec(Source source, PhysicalPlan child, Expression condition) {
        this(source, child, condition, false);
    }

    public FilterExec(Source source, PhysicalPlan child, Expression condition, boolean onAggs) {
        super(source, child);
        this.condition = condition;
        this.onAggs = onAggs;
    }

    protected NodeInfo<FilterExec> info() {
        return NodeInfo.create((Node)this, FilterExec::new, (Object)this.child(), (Object)this.condition, (Object)this.onAggs);
    }

    @Override
    protected FilterExec replaceChild(PhysicalPlan newChild) {
        return new FilterExec(this.source(), newChild, this.condition, this.onAggs);
    }

    public Expression condition() {
        return this.condition;
    }

    public boolean onAggs() {
        return this.onAggs;
    }

    @Override
    public List<Attribute> output() {
        return this.child().output();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.condition, this.onAggs, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilterExec other = (FilterExec)obj;
        return this.onAggs == other.onAggs && Objects.equals(this.condition, other.condition) && Objects.equals(this.child(), other.child());
    }
}

