/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetServiceAccountCredentialsRequest
extends ActionRequest {
    private final String namespace;
    private final String serviceName;

    public GetServiceAccountCredentialsRequest(String namespace, String serviceName) {
        this.namespace = namespace;
        this.serviceName = serviceName;
    }

    public GetServiceAccountCredentialsRequest(StreamInput in) throws IOException {
        super(in);
        this.namespace = in.readString();
        this.serviceName = in.readString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountCredentialsRequest that = (GetServiceAccountCredentialsRequest)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.serviceName, that.serviceName);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.serviceName);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.namespace);
        out.writeString(this.serviceName);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty(this.namespace)) {
            validationException = ValidateActions.addValidationError("service account namespace is required", validationException);
        }
        if (Strings.isNullOrEmpty(this.serviceName)) {
            validationException = ValidateActions.addValidationError("service account service-name is required", validationException);
        }
        return validationException;
    }
}

