/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.regression;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TimingStats
implements Writeable,
ToXContentObject {
    public static final ParseField ELAPSED_TIME = new ParseField("elapsed_time", new String[0]);
    public static final ParseField ITERATION_TIME = new ParseField("iteration_time", new String[0]);
    private final TimeValue elapsedTime;
    private final TimeValue iterationTime;

    public static TimingStats fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return TimingStats.createParser(ignoreUnknownFields).apply(parser, null);
    }

    private static ConstructingObjectParser<TimingStats, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<TimingStats, Void> parser = new ConstructingObjectParser<TimingStats, Void>("regression_timing_stats", ignoreUnknownFields, a -> new TimingStats(TimeValue.timeValueMillis((Long)a[0]), TimeValue.timeValueMillis((Long)a[1])));
        parser.declareLong(ConstructingObjectParser.constructorArg(), ELAPSED_TIME);
        parser.declareLong(ConstructingObjectParser.constructorArg(), ITERATION_TIME);
        return parser;
    }

    public TimingStats(TimeValue elapsedTime, TimeValue iterationTime) {
        this.elapsedTime = Objects.requireNonNull(elapsedTime);
        this.iterationTime = Objects.requireNonNull(iterationTime);
    }

    public TimingStats(StreamInput in) throws IOException {
        this.elapsedTime = in.readTimeValue();
        this.iterationTime = in.readTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.elapsedTime);
        out.writeTimeValue(this.iterationTime);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.humanReadableField(ELAPSED_TIME.getPreferredName(), ELAPSED_TIME.getPreferredName() + "_string", this.elapsedTime);
        builder.humanReadableField(ITERATION_TIME.getPreferredName(), ITERATION_TIME.getPreferredName() + "_string", this.iterationTime);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingStats that = (TimingStats)o;
        return Objects.equals(this.elapsedTime, that.elapsedTime) && Objects.equals(this.iterationTime, that.iterationTime);
    }

    public int hashCode() {
        return Objects.hash(this.elapsedTime, this.iterationTime);
    }
}

