/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ItemUsage;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;

public class LifecyclePolicyUtils {
    private LifecyclePolicyUtils() {
    }

    public static LifecyclePolicy loadPolicy(String name, String resource, NamedXContentRegistry xContentRegistry) {
        LifecyclePolicy lifecyclePolicy;
        block8: {
            BytesReference source = LifecyclePolicyUtils.load(resource);
            LifecyclePolicyUtils.validate(source);
            XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, LoggingDeprecationHandler.THROW_UNSUPPORTED_OPERATION, source.utf8ToString());
            try {
                LifecyclePolicy policy = LifecyclePolicy.parse(parser, name);
                policy.validate();
                lifecyclePolicy = policy;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("unable to load policy [" + name + "] from [" + resource + "]", e);
                }
            }
            parser.close();
        }
        return lifecyclePolicy;
    }

    private static BytesReference load(String name) throws IOException {
        try (InputStream is = LifecyclePolicyUtils.class.getResourceAsStream(name);){
            BytesArray bytesArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Streams.copy(is, out);
                bytesArray = new BytesArray(out.toByteArray());
            }
            return bytesArray;
        }
    }

    private static void validate(BytesReference source) {
        if (source == null) {
            throw new ElasticsearchParseException("policy must not be null", new Object[0]);
        }
        try {
            XContentHelper.convertToMap(source, false, XContentType.JSON).v2();
        }
        catch (NotXContentException e) {
            throw new ElasticsearchParseException("policy must not be empty", new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("invalid policy", (Throwable)e, new Object[0]);
        }
    }

    public static ItemUsage calculateUsage(IndexNameExpressionResolver indexNameExpressionResolver, ClusterState state, String policyName) {
        List<String> indices = state.metadata().indices().values().stream().filter(indexMetadata -> policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings()))).map(indexMetadata -> indexMetadata.getIndex().getName()).collect(Collectors.toList());
        List<String> allDataStreams = indexNameExpressionResolver.dataStreamNames(state, IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN, new String[0]);
        List<String> dataStreams = allDataStreams.stream().filter(dsName -> {
            String indexTemplate = MetadataIndexTemplateService.findV2Template(state.metadata(), dsName, false);
            if (indexTemplate != null) {
                Settings settings = MetadataIndexTemplateService.resolveSettings(state.metadata(), indexTemplate);
                return policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(settings));
            }
            return false;
        }).collect(Collectors.toList());
        List<String> composableTemplates = state.metadata().templatesV2().keySet().stream().filter(templateName -> {
            Settings settings = MetadataIndexTemplateService.resolveSettings(state.metadata(), templateName);
            return policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(settings));
        }).collect(Collectors.toList());
        return new ItemUsage(indices, dataStreams, composableTemplates);
    }
}

