/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.FreezeStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;

public class FreezeAction
implements LifecycleAction {
    private static final Logger logger = LogManager.getLogger(FreezeAction.class);
    public static final String NAME = "freeze";
    public static final String CONDITIONAL_SKIP_FREEZE_STEP = "branch-freeze-check-prerequisites";
    private static final ObjectParser<FreezeAction, Void> PARSER = new ObjectParser("freeze", FreezeAction::new);

    public static FreezeAction parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public FreezeAction() {
    }

    public FreezeAction(StreamInput in) {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey preFreezeMergeBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_SKIP_FREEZE_STEP);
        Step.StepKey checkNotWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey freezeStepKey = new Step.StepKey(phase, NAME, NAME);
        BranchingStep conditionalSkipFreezeStep = new BranchingStep(preFreezeMergeBranchingKey, checkNotWriteIndex, nextStepKey, (index, clusterState) -> {
            IndexMetadata indexMetadata = clusterState.getMetadata().index((Index)index);
            assert (indexMetadata != null) : "index " + index.getName() + " must exist in the cluster state";
            String policyName = LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings());
            if (indexMetadata.getSettings().get("index.store.snapshot.index_name") != null) {
                logger.warn("[{}] action is configured for index [{}] in policy [{}] which is mounted as searchable snapshot. Skipping this action", (Object)NAME, (Object)index.getName(), (Object)policyName);
                return true;
            }
            if (indexMetadata.getSettings().getAsBoolean("index.frozen", false).booleanValue()) {
                logger.debug("skipping [{}] action for index [{}] in policy [{}] as the index is already frozen", (Object)NAME, (Object)index.getName(), (Object)policyName);
                return true;
            }
            return false;
        });
        CheckNotDataStreamWriteIndexStep checkNoWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNotWriteIndex, freezeStepKey);
        FreezeStep freezeStep = new FreezeStep(freezeStepKey, nextStepKey, client);
        return Arrays.asList(conditionalSkipFreezeStep, checkNoWriteIndexStep, freezeStep);
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }

    public String toString() {
        return Strings.toString(this);
    }
}

