/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ClusterNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.protocol.xpack.license.LicenseStatus;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterService;

public final class SourceDestValidator {
    public static final String SOURCE_INDEX_MISSING = "Source index [{0}] does not exist";
    public static final String DEST_IN_SOURCE = "Destination index [{0}] is included in source expression [{1}]";
    public static final String DEST_LOWERCASE = "Destination index [{0}] must be lowercase";
    public static final String NEEDS_REMOTE_CLUSTER_SEARCH = "Source index is configured with a remote index pattern(s) [{0}] but the current node [{1}] is not allowed to connect to remote clusters. Please enable " + DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " for all {2} nodes.";
    public static final String ERROR_REMOTE_CLUSTER_SEARCH = "Error resolving remote source: {0}";
    public static final String UNKNOWN_REMOTE_CLUSTER_LICENSE = "Error during license check ({0}) for remote cluster alias(es) {1}, error: {2}";
    public static final String FEATURE_NOT_LICENSED_REMOTE_CLUSTER_LICENSE = "License check failed for remote cluster alias [{0}], at least a [{1}] license is required, found license [{2}]";
    public static final String REMOTE_CLUSTER_LICENSE_INACTIVE = "License check failed for remote cluster alias [{0}], license is not active";
    public static final String REMOTE_SOURCE_INDICES_NOT_SUPPORTED = "remote source indices are not supported";
    public static final String REMOTE_CLUSTERS_TOO_OLD = "remote clusters are expected to run at least version [{0}] (reason: [{1}]), but the following clusters were too old: [{2}]";
    public static final String PIPELINE_MISSING = "Pipeline with id [{0}] could not be found";
    private static final ClusterNameExpressionResolver clusterNameExpressionResolver = new ClusterNameExpressionResolver();
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final RemoteClusterService remoteClusterService;
    private final RemoteClusterLicenseChecker remoteClusterLicenseChecker;
    private final IngestService ingestService;
    private final String nodeName;
    private final String license;
    private static final IndicesOptions DEFAULT_INDICES_OPTIONS_FOR_VALIDATION = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();
    public static final SourceDestValidation SOURCE_MISSING_VALIDATION = new SourceMissingValidation();
    public static final SourceDestValidation DESTINATION_IN_SOURCE_VALIDATION = new DestinationInSourceValidation();
    public static final SourceDestValidation DESTINATION_SINGLE_INDEX_VALIDATION = new DestinationSingleIndexValidation();
    public static final SourceDestValidation REMOTE_SOURCE_NOT_SUPPORTED_VALIDATION = new RemoteSourceNotSupportedValidation();
    public static final SourceDestValidation DESTINATION_PIPELINE_MISSING_VALIDATION = new DestinationPipelineMissingValidation();

    public SourceDestValidator(IndexNameExpressionResolver indexNameExpressionResolver, RemoteClusterService remoteClusterService, RemoteClusterLicenseChecker remoteClusterLicenseChecker, IngestService ingestService, String nodeName, String license) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.remoteClusterService = remoteClusterService;
        this.remoteClusterLicenseChecker = remoteClusterLicenseChecker;
        this.ingestService = ingestService;
        this.nodeName = nodeName;
        this.license = license;
    }

    public void validate(ClusterState clusterState, String[] source, String destIndex, @Nullable String destPipeline, List<SourceDestValidation> validations, ActionListener<Boolean> listener) {
        Context context = new Context(clusterState, this.indexNameExpressionResolver, this.remoteClusterService, this.remoteClusterLicenseChecker, this.ingestService, source, destIndex, destPipeline, this.nodeName, this.license);
        ActionListener<Context> validationListener = ActionListener.wrap(c -> {
            if (c.getValidationException() != null) {
                listener.onFailure(c.getValidationException());
            } else {
                listener.onResponse(true);
            }
        }, listener::onFailure);
        for (int i = validations.size() - 1; i >= 0; --i) {
            SourceDestValidation validation = validations.get(i);
            ActionListener<Context> previousValidationListener = validationListener;
            validationListener = ActionListener.wrap(c -> validation.validate((Context)c, previousValidationListener), listener::onFailure);
        }
        validationListener.onResponse(context);
    }

    public static ActionRequestValidationException validateRequest(@Nullable ActionRequestValidationException validationException, @Nullable String destIndex) {
        try {
            if (destIndex != null) {
                MetadataCreateIndexService.validateIndexOrAliasName(destIndex, InvalidIndexNameException::new);
                if (!destIndex.toLowerCase(Locale.ROOT).equals(destIndex)) {
                    validationException = ValidateActions.addValidationError(SourceDestValidator.getMessage(DEST_LOWERCASE, destIndex), validationException);
                }
            }
        }
        catch (InvalidIndexNameException ex) {
            validationException = ValidateActions.addValidationError(ex.getMessage(), validationException);
        }
        return validationException;
    }

    private static String getMessage(String message, Object ... args) {
        return new MessageFormat(message, Locale.ROOT).format(args);
    }

    private static List<String> remoteClusterAliases(Set<String> remoteClusters, List<String> indices) {
        return indices.stream().filter(RemoteClusterLicenseChecker::isRemoteIndex).map(index -> index.substring(0, index.indexOf(58))).distinct().flatMap(clusterExpression -> {
            List<String> resolved = clusterNameExpressionResolver.resolveClusterNames(remoteClusters, (String)clusterExpression);
            if (resolved.isEmpty()) {
                throw new NoSuchRemoteClusterException((String)clusterExpression);
            }
            return resolved.stream();
        }).distinct().collect(Collectors.toList());
    }

    static class Context {
        private final ClusterState state;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final RemoteClusterService remoteClusterService;
        private final RemoteClusterLicenseChecker remoteClusterLicenseChecker;
        private final IngestService ingestService;
        private final String[] source;
        private final String destIndex;
        private final String destPipeline;
        private final String nodeName;
        private final String license;
        private ValidationException validationException = null;
        private SortedSet<String> resolvedSource = null;
        private SortedSet<String> resolvedRemoteSource = null;
        private String resolvedDest = null;

        Context(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver, RemoteClusterService remoteClusterService, RemoteClusterLicenseChecker remoteClusterLicenseChecker, IngestService ingestService, String[] source, String destIndex, String destPipeline, String nodeName, String license) {
            this.state = state;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
            this.remoteClusterService = remoteClusterService;
            this.remoteClusterLicenseChecker = remoteClusterLicenseChecker;
            this.ingestService = ingestService;
            this.source = source;
            this.destIndex = destIndex;
            this.destPipeline = destPipeline;
            this.nodeName = nodeName;
            this.license = license;
        }

        public ClusterState getState() {
            return this.state;
        }

        public RemoteClusterService getRemoteClusterService() {
            return this.remoteClusterService;
        }

        public RemoteClusterLicenseChecker getRemoteClusterLicenseChecker() {
            return this.remoteClusterLicenseChecker;
        }

        public IndexNameExpressionResolver getIndexNameExpressionResolver() {
            return this.indexNameExpressionResolver;
        }

        public IngestService getIngestService() {
            return this.ingestService;
        }

        public boolean isRemoteSearchEnabled() {
            return this.remoteClusterLicenseChecker != null;
        }

        public String[] getSource() {
            return this.source;
        }

        public String getDestIndex() {
            return this.destIndex;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getLicense() {
            return this.license;
        }

        public SortedSet<String> resolveSource() {
            if (this.resolvedSource == null) {
                this.resolveLocalAndRemoteSource();
            }
            return this.resolvedSource;
        }

        public SortedSet<String> resolveRemoteSource() {
            if (this.resolvedRemoteSource == null) {
                this.resolveLocalAndRemoteSource();
            }
            return this.resolvedRemoteSource;
        }

        public String resolveDest() {
            if (this.resolvedDest == null) {
                try {
                    Index singleWriteIndex = this.indexNameExpressionResolver.concreteWriteIndex(this.state, IndicesOptions.lenientExpandOpen(), this.destIndex, true, false);
                    this.resolvedDest = singleWriteIndex != null ? singleWriteIndex.getName() : this.destIndex;
                }
                catch (IllegalArgumentException e) {
                    this.addValidationError(e.getMessage(), new Object[0]);
                    throw this.validationException;
                }
            }
            return this.resolvedDest;
        }

        public ValidationException addValidationError(String error, Object ... args) {
            if (this.validationException == null) {
                this.validationException = new ValidationException();
            }
            this.validationException.addValidationError(SourceDestValidator.getMessage(error, args));
            return this.validationException;
        }

        public ValidationException getValidationException() {
            return this.validationException;
        }

        public Set<String> getRegisteredRemoteClusterNames() {
            return this.remoteClusterService.getRegisteredRemoteClusterNames();
        }

        public Version getRemoteClusterVersion(String cluster) {
            return this.remoteClusterService.getConnection(cluster).getVersion();
        }

        private void resolveLocalAndRemoteSource() {
            this.resolvedSource = new TreeSet<String>(Arrays.asList(this.source));
            this.resolvedRemoteSource = new TreeSet<String>(RemoteClusterLicenseChecker.remoteIndices(this.resolvedSource));
            this.resolvedSource.removeAll(this.resolvedRemoteSource);
            if (!this.resolvedSource.isEmpty()) {
                this.resolvedSource = new TreeSet<String>(Arrays.asList(this.indexNameExpressionResolver.concreteIndexNames(this.state, DEFAULT_INDICES_OPTIONS_FOR_VALIDATION, true, this.resolvedSource.toArray(Strings.EMPTY_ARRAY))));
            }
        }
    }

    public static interface SourceDestValidation {
        public void validate(Context var1, ActionListener<Context> var2);
    }

    static class SourceMissingValidation
    implements SourceDestValidation {
        SourceMissingValidation() {
        }

        @Override
        public void validate(Context context, ActionListener<Context> listener) {
            try {
                if (context.resolveSource().isEmpty() && context.resolveRemoteSource().isEmpty() && context.getSource().length == 0) {
                    context.addValidationError(SourceDestValidator.SOURCE_INDEX_MISSING, Strings.arrayToCommaDelimitedString(context.getSource()));
                }
            }
            catch (IndexNotFoundException e) {
                context.addValidationError(e.getMessage(), new Object[0]);
            }
            listener.onResponse(context);
        }
    }

    static class DestinationInSourceValidation
    implements SourceDestValidation {
        DestinationInSourceValidation() {
        }

        @Override
        public void validate(Context context, ActionListener<Context> listener) {
            String destIndex = context.getDestIndex();
            boolean foundSourceInDest = false;
            for (String src : context.getSource()) {
                if (!Regex.simpleMatch(src, destIndex)) continue;
                context.addValidationError(SourceDestValidator.DEST_IN_SOURCE, destIndex, src);
                foundSourceInDest = true;
            }
            if (foundSourceInDest) {
                listener.onResponse(context);
                return;
            }
            if (context.resolveSource().contains(destIndex)) {
                context.addValidationError(SourceDestValidator.DEST_IN_SOURCE, destIndex, Strings.arrayToCommaDelimitedString(context.getSource()));
                listener.onResponse(context);
                return;
            }
            if (context.resolveSource().contains(context.resolveDest())) {
                context.addValidationError(SourceDestValidator.DEST_IN_SOURCE, context.resolveDest(), Strings.collectionToCommaDelimitedString(context.resolveSource()));
            }
            listener.onResponse(context);
        }
    }

    static class DestinationSingleIndexValidation
    implements SourceDestValidation {
        DestinationSingleIndexValidation() {
        }

        @Override
        public void validate(Context context, ActionListener<Context> listener) {
            context.resolveDest();
            listener.onResponse(context);
        }
    }

    static class RemoteSourceNotSupportedValidation
    implements SourceDestValidation {
        RemoteSourceNotSupportedValidation() {
        }

        @Override
        public void validate(Context context, ActionListener<Context> listener) {
            if (!context.resolveRemoteSource().isEmpty()) {
                context.addValidationError(SourceDestValidator.REMOTE_SOURCE_INDICES_NOT_SUPPORTED, new Object[0]);
            }
            listener.onResponse(context);
        }
    }

    static class DestinationPipelineMissingValidation
    implements SourceDestValidation {
        DestinationPipelineMissingValidation() {
        }

        @Override
        public void validate(Context context, ActionListener<Context> listener) {
            if (context.destPipeline != null && context.ingestService.getPipeline(context.destPipeline) == null) {
                context.addValidationError(SourceDestValidator.PIPELINE_MISSING, context.destPipeline);
            }
            listener.onResponse(context);
        }
    }

    public static class RemoteClusterMinimumVersionValidation
    implements SourceDestValidation {
        private final Version minExpectedVersion;
        private final String reason;

        public RemoteClusterMinimumVersionValidation(Version minExpectedVersion, String reason) {
            this.minExpectedVersion = minExpectedVersion;
            this.reason = reason;
        }

        public Version getMinExpectedVersion() {
            return this.minExpectedVersion;
        }

        public String getReason() {
            return this.reason;
        }

        @Override
        public void validate(Context context, ActionListener<Context> listener) {
            Map remoteClusterVersions;
            ArrayList<String> remoteIndices = new ArrayList<String>(context.resolveRemoteSource());
            try {
                List<String> remoteAliases = RemoteClusterLicenseChecker.remoteClusterAliases(context.getRegisteredRemoteClusterNames(), remoteIndices);
                remoteClusterVersions = remoteAliases.stream().collect(Collectors.toMap(Function.identity(), context::getRemoteClusterVersion));
            }
            catch (NoSuchRemoteClusterException e2) {
                context.addValidationError(e2.getMessage(), new Object[0]);
                listener.onResponse(context);
                return;
            }
            catch (Exception e3) {
                context.addValidationError(SourceDestValidator.ERROR_REMOTE_CLUSTER_SEARCH, e3.getMessage());
                listener.onResponse(context);
                return;
            }
            Map<String, Version> oldRemoteClusterVersions = remoteClusterVersions.entrySet().stream().filter(entry -> ((Version)entry.getValue()).before(this.minExpectedVersion)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!oldRemoteClusterVersions.isEmpty()) {
                context.addValidationError(SourceDestValidator.REMOTE_CLUSTERS_TOO_OLD, this.minExpectedVersion, this.reason, oldRemoteClusterVersions.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + " (" + e.getValue() + ")").collect(Collectors.joining(", ")));
            }
            listener.onResponse(context);
        }
    }

    public static class RemoteSourceEnabledAndRemoteLicenseValidation
    implements SourceDestValidation {
        private final String nodeRoleThatRequiresRemoteClusterClient;

        public RemoteSourceEnabledAndRemoteLicenseValidation(String nodeRoleThatRequiresRemoteClusterClient) {
            this.nodeRoleThatRequiresRemoteClusterClient = nodeRoleThatRequiresRemoteClusterClient;
        }

        @Override
        public void validate(Context context, ActionListener<Context> listener) {
            List remoteAliases;
            if (context.resolveRemoteSource().isEmpty()) {
                listener.onResponse(context);
                return;
            }
            ArrayList<String> remoteIndices = new ArrayList<String>(context.resolveRemoteSource());
            if (!context.isRemoteSearchEnabled()) {
                context.addValidationError(NEEDS_REMOTE_CLUSTER_SEARCH, context.resolveRemoteSource(), context.getNodeName(), this.nodeRoleThatRequiresRemoteClusterClient);
                listener.onResponse(context);
                return;
            }
            try {
                remoteAliases = SourceDestValidator.remoteClusterAliases(context.getRegisteredRemoteClusterNames(), remoteIndices);
            }
            catch (NoSuchRemoteClusterException e2) {
                context.addValidationError(e2.getMessage(), new Object[0]);
                listener.onResponse(context);
                return;
            }
            catch (Exception e3) {
                context.addValidationError(SourceDestValidator.ERROR_REMOTE_CLUSTER_SEARCH, e3.getMessage());
                listener.onResponse(context);
                return;
            }
            context.getRemoteClusterLicenseChecker().checkRemoteClusterLicenses(remoteAliases, ActionListener.wrap(response -> {
                if (!response.isSuccess()) {
                    if (response.remoteClusterLicenseInfo().licenseInfo().getStatus() != LicenseStatus.ACTIVE) {
                        context.addValidationError(SourceDestValidator.REMOTE_CLUSTER_LICENSE_INACTIVE, response.remoteClusterLicenseInfo().clusterAlias());
                    } else {
                        context.addValidationError(SourceDestValidator.FEATURE_NOT_LICENSED_REMOTE_CLUSTER_LICENSE, response.remoteClusterLicenseInfo().clusterAlias(), context.getLicense(), response.remoteClusterLicenseInfo().licenseInfo().getType());
                    }
                }
                listener.onResponse(context);
            }, e -> {
                context.addValidationError(SourceDestValidator.UNKNOWN_REMOTE_CLUSTER_LICENSE, context.getLicense(), remoteAliases, e.getMessage());
                listener.onResponse(context);
            }));
        }
    }
}

