/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.EventHandler;
import org.elasticsearch.nio.NioGroup;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioSelectorGroup;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.transport.nio.NioTransportPlugin;

public final class NioGroupFactory {
    private final Logger logger;
    private final Settings settings;
    private final int httpWorkerCount;
    private RefCountedNioGroup refCountedGroup;

    public NioGroupFactory(Settings settings, Logger logger) {
        this.logger = logger;
        this.settings = settings;
        this.httpWorkerCount = NioTransportPlugin.NIO_HTTP_WORKER_COUNT.get(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public synchronized NioGroup getTransportGroup() throws IOException {
        return this.getGenericGroup();
    }

    public synchronized NioGroup getHttpGroup() throws IOException {
        if (this.httpWorkerCount == 0) {
            return this.getGenericGroup();
        }
        return new NioSelectorGroup(EsExecutors.daemonThreadFactory(this.settings, "http_server_worker"), this.httpWorkerCount, s -> new EventHandler(this::onException, (Supplier<NioSelector>)s));
    }

    private NioGroup getGenericGroup() throws IOException {
        if (this.refCountedGroup == null) {
            ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, "transport_worker");
            NioSelectorGroup nioGroup = new NioSelectorGroup(threadFactory, NioTransportPlugin.NIO_WORKER_COUNT.get(this.settings), s -> new EventHandler(this::onException, (Supplier<NioSelector>)s));
            this.refCountedGroup = new RefCountedNioGroup(nioGroup);
            return new WrappedNioGroup(this.refCountedGroup);
        }
        this.refCountedGroup.incRef();
        return new WrappedNioGroup(this.refCountedGroup);
    }

    private void onException(Exception exception) {
        this.logger.warn(new ParameterizedMessage("exception caught on transport layer [thread={}]", (Object)Thread.currentThread().getName()), (Throwable)exception);
    }

    private static class RefCountedNioGroup
    extends AbstractRefCounted
    implements NioGroup {
        private final NioSelectorGroup nioGroup;

        private RefCountedNioGroup(NioSelectorGroup nioGroup) {
            this.nioGroup = nioGroup;
        }

        @Override
        protected void closeInternal() {
            try {
                this.nioGroup.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public <S extends NioServerSocketChannel> S bindServerChannel(InetSocketAddress address, ChannelFactory<S, ?> factory) throws IOException {
            return this.nioGroup.bindServerChannel(address, factory);
        }

        @Override
        public <S extends NioSocketChannel> S openChannel(InetSocketAddress address, ChannelFactory<?, S> factory) throws IOException {
            return this.nioGroup.openChannel(address, factory);
        }

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException("Should not close. Instead use decRef call.");
        }
    }

    private static class WrappedNioGroup
    implements NioGroup {
        private final RefCountedNioGroup refCountedNioGroup;
        private final AtomicBoolean isOpen = new AtomicBoolean(true);

        private WrappedNioGroup(RefCountedNioGroup refCountedNioGroup) {
            this.refCountedNioGroup = refCountedNioGroup;
        }

        @Override
        public <S extends NioServerSocketChannel> S bindServerChannel(InetSocketAddress address, ChannelFactory<S, ?> factory) throws IOException {
            this.ensureOpen();
            return this.refCountedNioGroup.bindServerChannel(address, factory);
        }

        @Override
        public <S extends NioSocketChannel> S openChannel(InetSocketAddress address, ChannelFactory<?, S> factory) throws IOException {
            this.ensureOpen();
            return this.refCountedNioGroup.openChannel(address, factory);
        }

        @Override
        public void close() {
            if (this.isOpen.compareAndSet(true, false)) {
                this.refCountedNioGroup.decRef();
            }
        }

        private void ensureOpen() {
            if (!this.isOpen.get()) {
                throw new IllegalStateException("NioGroup is closed.");
            }
        }
    }
}

