/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

final class RoundRobinSupplier<S>
implements Supplier<S> {
    private final AtomicBoolean selectorsSet = new AtomicBoolean(false);
    private volatile S[] selectors;
    private AtomicInteger counter = new AtomicInteger(0);

    RoundRobinSupplier() {
        this.selectors = null;
    }

    RoundRobinSupplier(S[] selectors) {
        this.selectors = selectors;
        this.selectorsSet.set(true);
    }

    @Override
    public S get() {
        S[] currentSelectors = this.selectors;
        return currentSelectors[this.counter.getAndIncrement() % currentSelectors.length];
    }

    void setSelectors(S[] selectors) {
        if (!this.selectorsSet.compareAndSet(false, true)) {
            throw new AssertionError((Object)"Selectors already set. Should only be set once.");
        }
        this.selectors = selectors;
    }

    int count() {
        return this.selectors.length;
    }
}

