/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketPermission;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.Policy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.bootstrap.ESPolicy;
import org.elasticsearch.bootstrap.ElasticsearchUncaughtExceptionHandler;
import org.elasticsearch.bootstrap.FilePermissionUtils;
import org.elasticsearch.bootstrap.PluginPolicyInfo;
import org.elasticsearch.bootstrap.PolicyUtil;
import org.elasticsearch.cli.Command;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.secure_sm.SecureSM;
import org.elasticsearch.transport.TcpTransport;

final class Security {
    private Security() {
    }

    static void setSecurityManager(SecurityManager sm) {
        System.setSecurityManager(sm);
    }

    static void configure(Environment environment, boolean filterBadDefaults) throws IOException, NoSuchAlgorithmException {
        Map<String, URL> codebases = PolicyUtil.getCodebaseJarMap(JarHell.parseClassPath());
        Policy.setPolicy(new ESPolicy(codebases, Security.createPermissions(environment), Security.getPluginAndModulePermissions(environment), filterBadDefaults, Security.createRecursiveDataPathPermission(environment)));
        String[] classesThatCanExit = new String[]{ElasticsearchUncaughtExceptionHandler.PrivilegedHaltAction.class.getName().replace("$", "\\$"), Command.class.getName()};
        Security.setSecurityManager((SecurityManager)new SecureSM(classesThatCanExit));
        Security.selfTest();
    }

    @SuppressForbidden(reason="proper use of URL")
    static Map<String, Policy> getPluginAndModulePermissions(Environment environment) throws IOException {
        HashMap map = new HashMap();
        Consumer<PluginPolicyInfo> addPolicy = pluginPolicy -> {
            if (pluginPolicy == null) {
                return;
            }
            for (URL jar : pluginPolicy.jars) {
                if (map.put(jar.getFile(), pluginPolicy.policy) == null) continue;
                throw new IllegalStateException("per-plugin permissions already granted for jar file: " + jar);
            }
        };
        for (Path plugin : PluginsService.findPluginDirs(environment.pluginsFile())) {
            addPolicy.accept(PolicyUtil.getPluginPolicyInfo(plugin, environment.tmpFile()));
        }
        for (Path plugin : PluginsService.findPluginDirs(environment.modulesFile())) {
            addPolicy.accept(PolicyUtil.getModulePolicyInfo(plugin, environment.tmpFile()));
        }
        return Collections.unmodifiableMap(map);
    }

    static Permissions createPermissions(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        Security.addClasspathPermissions(policy);
        Security.addFilePermissions(policy, environment);
        Security.addBindPermissions(policy, environment.settings());
        return policy;
    }

    private static Permissions createRecursiveDataPathPermission(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete", true);
        }
        return policy;
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static void addClasspathPermissions(Permissions policy) throws IOException {
        for (URL url : JarHell.parseClassPath()) {
            Path path;
            try {
                path = PathUtils.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                FilePermissionUtils.addDirectoryPath(policy, "class.path", path, "read,readlink", false);
                continue;
            }
            FilePermissionUtils.addSingleFilePath(policy, path, "read,readlink");
        }
    }

    static void addFilePermissions(Permissions policy, Environment environment) throws IOException {
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.binFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.libFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.modulesFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.pluginsFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, "path.conf'", environment.configFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, "java.io.tmpdir", environment.tmpFile(), "read,readlink,write,delete", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_LOGS_SETTING.getKey(), environment.logsFile(), "read,readlink,write,delete", false);
        if (environment.sharedDataFile() != null) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_SHARED_DATA_SETTING.getKey(), environment.sharedDataFile(), "read,readlink,write,delete", false);
        }
        HashSet<Path> dataFilesPaths = new HashSet<Path>();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete", false);
            try {
                Path realPath = path.toRealPath(new LinkOption[0]);
                if (dataFilesPaths.add(realPath)) continue;
                throw new IllegalStateException("path [" + realPath + "] is duplicated by [" + path + "]");
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to access [" + path + "]", e);
            }
        }
        for (Path path : environment.repoFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_REPO_SETTING.getKey(), path, "read,readlink,write,delete", false);
        }
        if (environment.pidFile() != null) {
            FilePermissionUtils.addSingleFilePath(policy, environment.pidFile(), "delete");
        }
    }

    private static void addBindPermissions(Permissions policy, Settings settings) {
        Security.addSocketPermissionForHttp(policy, settings);
        Security.addSocketPermissionForTransportProfiles(policy, settings);
    }

    private static void addSocketPermissionForHttp(Permissions policy, Settings settings) {
        String httpRange = HttpTransportSettings.SETTING_HTTP_PORT.get(settings).getPortRangeString();
        Security.addSocketPermissionForPortRange(policy, httpRange);
    }

    private static void addSocketPermissionForTransportProfiles(Permissions policy, Settings settings) {
        Set<TcpTransport.ProfileSettings> profiles = TcpTransport.getProfileSettings(settings);
        HashSet<String> uniquePortRanges = new HashSet<String>();
        for (TcpTransport.ProfileSettings profile : profiles) {
            if (!uniquePortRanges.add(profile.portOrRange)) continue;
            Security.addSocketPermissionForPortRange(policy, profile.portOrRange);
        }
    }

    private static void addSocketPermissionForPortRange(Permissions policy, String portRange) {
        policy.add(new SocketPermission("*:" + portRange, "listen,resolve"));
    }

    static void ensureDirectoryExists(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path.getFileSystem().provider().checkAccess(path.toRealPath(new LinkOption[0]), AccessMode.READ);
        } else {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                NotDirectoryException e2 = new NotDirectoryException(path.toString());
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @SuppressForbidden(reason="accesses jvm default tempdir as a self-test")
    static void selfTest() throws IOException {
        try {
            Path p = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {}
        }
        catch (SecurityException problem) {
            throw new SecurityException("Security misconfiguration: cannot access java.io.tmpdir", problem);
        }
    }

    static boolean prepopulateSecurityCaller() {
        Field f;
        try {
            f = Security.getDeclaredField(Class.forName("java.lang.System$CallersHolder", true, null), "callers");
        }
        catch (ClassNotFoundException | NoSuchFieldException ignore) {
            return false;
        }
        try {
            Class<?> c = Class.forName("sun.misc.Unsafe");
            Object theUnsafe = Security.setAccessible(Security.getDeclaredField(c, "theUnsafe")).get(null);
            Method m = c.getMethod("staticFieldBase", Field.class);
            Object base = m.invoke(theUnsafe, f);
            m = c.getMethod("staticFieldOffset", Field.class);
            long offset = (Long)m.invoke(theUnsafe, f);
            m = c.getMethod("getObject", Object.class, Long.TYPE);
            Object callers = m.invoke(theUnsafe, base, offset);
            if (Map.class.isAssignableFrom(callers.getClass())) {
                Map map = (Map)Map.class.cast(callers);
                map.put(Security.class, true);
                return true;
            }
        }
        catch (Throwable t) {
            throw new ElasticsearchException(t);
        }
        return false;
    }

    @SuppressForbidden(reason="access violation required")
    private static Field setAccessible(Field field) {
        field.setAccessible(true);
        return field;
    }

    @SuppressForbidden(reason="access violation required")
    private static Field getDeclaredField(Class<?> c, String name) throws NoSuchFieldException {
        return c.getDeclaredField(name);
    }
}

