/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DistinguishedNameMatchingRule
extends MatchingRule {
    private static final DistinguishedNameMatchingRule INSTANCE = new DistinguishedNameMatchingRule();
    public static final String EQUALITY_RULE_NAME = "distinguishedNameMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("distinguishedNameMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.1";
    private static final long serialVersionUID = -2617356571703597868L;

    public static DistinguishedNameMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    public String getOrderingMatchingRuleName() {
        return null;
    }

    @Override
    public String getOrderingMatchingRuleOID() {
        return null;
    }

    @Override
    public String getSubstringMatchingRuleName() {
        return null;
    }

    @Override
    public String getSubstringMatchingRuleOID() {
        return null;
    }

    @Override
    public boolean valuesMatch(ASN1OctetString value1, ASN1OctetString value2) throws LDAPException {
        DN dn2;
        DN dn1;
        try {
            dn1 = new DN(value1.stringValue());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, le.getMessage(), le);
        }
        try {
            dn2 = new DN(value2.stringValue());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, le.getMessage(), le);
        }
        return dn1.equals(dn2);
    }

    @Override
    public boolean matchesAnyValue(ASN1OctetString assertionValue, ASN1OctetString[] attributeValues) throws LDAPException {
        DN assertionValueDN;
        if (assertionValue == null || attributeValues == null || attributeValues.length == 0) {
            return false;
        }
        try {
            assertionValueDN = new DN(assertionValue.stringValue());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, le.getMessage(), le);
        }
        for (ASN1OctetString attributeValue : attributeValues) {
            try {
                if (!assertionValueDN.equals(new DN(attributeValue.stringValue()))) continue;
                return true;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return false;
    }

    @Override
    public boolean matchesSubstring(ASN1OctetString value, ASN1OctetString subInitial, ASN1OctetString[] subAny, ASN1OctetString subFinal) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    public int compareValues(ASN1OctetString value1, ASN1OctetString value2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    public ASN1OctetString normalize(ASN1OctetString value) throws LDAPException {
        try {
            DN dn = new DN(value.stringValue());
            return new ASN1OctetString(dn.toNormalizedString());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, le.getMessage(), le);
        }
    }

    @Override
    public ASN1OctetString normalizeSubstring(ASN1OctetString value, byte substringType) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_DN_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

