/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;

public class EnrichCache {
    protected final Cache<CacheKey, CompletableFuture<SearchResponse>> cache;
    private volatile Metadata metadata;

    EnrichCache(long maxSize) {
        this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
    }

    CompletableFuture<SearchResponse> get(SearchRequest searchRequest) {
        CacheKey cacheKey = this.toKey(searchRequest);
        return (CompletableFuture)this.cache.get((Object)cacheKey);
    }

    void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public EnrichStatsAction.Response.CacheStats getStats(String localNodeId) {
        Cache.CacheStats cacheStats = this.cache.stats();
        return new EnrichStatsAction.Response.CacheStats(localNodeId, (long)this.cache.count(), cacheStats.getHits(), cacheStats.getMisses(), cacheStats.getEvictions());
    }

    public void resolveOrDispatchSearch(SearchRequest searchRequest, BiConsumer<SearchRequest, ActionListener<SearchResponse>> searchDispatcher, BiConsumer<SearchResponse, Exception> callBack) {
        CacheKey cacheKey = this.toKey(searchRequest);
        try {
            CompletableFuture cacheEntry = (CompletableFuture)this.cache.computeIfAbsent((Object)cacheKey, request -> {
                CompletableFuture completableFuture = new CompletableFuture();
                searchDispatcher.accept(searchRequest, ActionListener.wrap(completableFuture::complete, completableFuture::completeExceptionally));
                return completableFuture;
            });
            cacheEntry.whenComplete((response, throwable) -> {
                if (throwable != null) {
                    this.cache.invalidate((Object)cacheKey, (Object)cacheEntry);
                    if (throwable instanceof Exception) {
                        callBack.accept((SearchResponse)response, (Exception)throwable);
                        return;
                    }
                    throw (Error)throwable;
                }
                callBack.accept((SearchResponse)response, (Exception)null);
            });
        }
        catch (ExecutionException e) {
            callBack.accept(null, e);
        }
    }

    protected CacheKey toKey(SearchRequest searchRequest) {
        String enrichIndex = this.getEnrichIndexKey(searchRequest);
        return new CacheKey(enrichIndex, searchRequest);
    }

    private String getEnrichIndexKey(SearchRequest searchRequest) {
        String alias = searchRequest.indices()[0];
        IndexAbstraction ia = (IndexAbstraction)this.metadata.getIndicesLookup().get(alias);
        return ((Index)ia.getIndices().get(0)).getName();
    }

    private static class CacheKey {
        final String enrichIndex;
        final SearchRequest searchRequest;

        private CacheKey(String enrichIndex, SearchRequest searchRequest) {
            this.enrichIndex = enrichIndex;
            this.searchRequest = searchRequest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.enrichIndex.equals(cacheKey.enrichIndex) && this.searchRequest.equals((Object)cacheKey.searchRequest);
        }

        public int hashCode() {
            return Objects.hash(this.enrichIndex, this.searchRequest);
        }
    }
}

