/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.adapt.jts;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.adapt.jts.ITagConverter;
import com.wdtinc.mapbox_vector_tile.encoding.MvtValue;
import com.wdtinc.mapbox_vector_tile.util.JdkUtils;
import java.util.LinkedHashMap;
import java.util.List;

public final class TagKeyValueMapConverter
implements ITagConverter {
    private final boolean nullIfEmpty;
    private final boolean addId;
    private final String idKey;

    public TagKeyValueMapConverter() {
        this(false);
    }

    public TagKeyValueMapConverter(boolean nullIfEmpty) {
        this.nullIfEmpty = nullIfEmpty;
        this.addId = false;
        this.idKey = null;
    }

    public TagKeyValueMapConverter(boolean nullIfEmpty, String idKey) {
        JdkUtils.requireNonNull(idKey);
        this.nullIfEmpty = nullIfEmpty;
        this.addId = true;
        this.idKey = idKey;
    }

    @Override
    public Object toUserData(Long id, List<Integer> tags, List<String> keysList, List<VectorTile.Tile.Value> valuesList) {
        if (this.nullIfEmpty && tags.size() < 1 && (!this.addId || id == null)) {
            return null;
        }
        LinkedHashMap<String, Object> userData = new LinkedHashMap<String, Object>((tags.size() + 1) / 2);
        for (int i = 0; i < tags.size() - 1; i += 2) {
            boolean valid;
            int keyIndex = tags.get(i);
            int valIndex = tags.get(i + 1);
            boolean bl = valid = keyIndex >= 0 && keyIndex < keysList.size() && valIndex >= 0 && valIndex < valuesList.size();
            if (!valid) continue;
            userData.put(keysList.get(keyIndex), MvtValue.toObject(valuesList.get(valIndex)));
        }
        if (this.addId) {
            userData.put(this.idKey, id);
        }
        return userData;
    }
}

