/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldQuery;

public class StringScriptFieldRangeQuery
extends AbstractStringScriptFieldQuery {
    private final String lowerValue;
    private final String upperValue;
    private final boolean includeLower;
    private final boolean includeUpper;

    public StringScriptFieldRangeQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, String lowerValue, String upperValue, boolean includeLower, boolean includeUpper) {
        super(script, leafFactory, fieldName);
        if (lowerValue == null && !includeLower) {
            throw new IllegalArgumentException("includeLower must be true when lowerValue is null (open ended)");
        }
        if (upperValue == null && !includeUpper) {
            throw new IllegalArgumentException("includeUpper must be true when upperValue is null (open ended)");
        }
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    @Override
    protected boolean matches(List<String> values) {
        for (String value : values) {
            boolean lowerOk = true;
            if (this.lowerValue != null) {
                int lct = this.lowerValue.compareTo(value);
                boolean bl = this.includeLower ? lct <= 0 : (lowerOk = lct < 0);
            }
            if (!lowerOk) continue;
            boolean upperOk = true;
            if (this.upperValue != null) {
                int uct = this.upperValue.compareTo(value);
                boolean bl = this.includeUpper ? uct >= 0 : (upperOk = uct > 0);
            }
            if (!upperOk) continue;
            return true;
        }
        return false;
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName())) {
            visitor.consumeTermsMatching((Query)this, this.fieldName(), () -> new ByteRunAutomaton(Automata.makeBinaryInterval((BytesRef)(this.lowerValue == null ? null : new BytesRef((CharSequence)this.lowerValue)), (boolean)this.includeLower, (BytesRef)(this.upperValue == null ? null : new BytesRef((CharSequence)this.upperValue)), (boolean)this.includeUpper)));
        }
    }

    public final String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().contentEquals(field)) {
            b.append(this.fieldName()).append(':');
        }
        b.append(this.includeLower ? (char)'[' : '{');
        b.append(this.lowerValue == null ? "*" : this.lowerValue);
        b.append(" TO ");
        b.append(this.upperValue == null ? "*" : this.upperValue);
        b.append(this.includeUpper ? (char)']' : '}');
        return b.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lowerValue, this.upperValue, this.includeLower, this.includeUpper);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        StringScriptFieldRangeQuery other = (StringScriptFieldRangeQuery)((Object)obj);
        return Objects.equals(this.lowerValue, other.lowerValue) && Objects.equals(this.upperValue, other.upperValue) && this.includeLower == other.includeLower && this.includeUpper == other.includeUpper;
    }

    String lowerValue() {
        return this.lowerValue;
    }

    String upperValue() {
        return this.upperValue;
    }

    boolean includeLower() {
        return this.includeLower;
    }

    boolean includeUpper() {
        return this.includeUpper;
    }
}

