/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class Extent {
    public int top;
    public int bottom;
    public int negLeft;
    public int negRight;
    public int posLeft;
    public int posRight;
    private static final byte NONE_SET = 0;
    private static final byte POSITIVE_SET = 1;
    private static final byte NEGATIVE_SET = 2;
    private static final byte CROSSES_LAT_AXIS = 3;
    private static final byte ALL_SET = 4;

    Extent() {
        this.top = Integer.MIN_VALUE;
        this.bottom = Integer.MAX_VALUE;
        this.negLeft = Integer.MAX_VALUE;
        this.negRight = Integer.MIN_VALUE;
        this.posLeft = Integer.MAX_VALUE;
        this.posRight = Integer.MIN_VALUE;
    }

    Extent(int top, int bottom, int negLeft, int negRight, int posLeft, int posRight) {
        this.top = top;
        this.bottom = bottom;
        this.negLeft = negLeft;
        this.negRight = negRight;
        this.posLeft = posLeft;
        this.posRight = posRight;
    }

    public void reset(int top, int bottom, int negLeft, int negRight, int posLeft, int posRight) {
        this.top = top;
        this.bottom = bottom;
        this.negLeft = negLeft;
        this.negRight = negRight;
        this.posLeft = posLeft;
        this.posRight = posRight;
    }

    public void addRectangle(int bottomLeftX, int bottomLeftY, int topRightX, int topRightY) {
        assert (bottomLeftX <= topRightX);
        assert (bottomLeftY <= topRightY);
        this.bottom = Math.min(this.bottom, bottomLeftY);
        this.top = Math.max(this.top, topRightY);
        if (bottomLeftX < 0 && topRightX < 0) {
            this.negLeft = Math.min(this.negLeft, bottomLeftX);
            this.negRight = Math.max(this.negRight, topRightX);
        } else if (bottomLeftX < 0) {
            this.negLeft = Math.min(this.negLeft, bottomLeftX);
            this.posRight = Math.max(this.posRight, topRightX);
            this.negRight = 0;
            this.posLeft = 0;
        } else {
            this.posLeft = Math.min(this.posLeft, bottomLeftX);
            this.posRight = Math.max(this.posRight, topRightX);
        }
    }

    static void readFromCompressed(StreamInput input, Extent extent) throws IOException {
        int posRight;
        int posLeft;
        int negRight;
        int negLeft;
        int top = input.readInt();
        int bottom = Math.toIntExact((long)top - input.readVLong());
        byte type = input.readByte();
        switch (type) {
            case 0: {
                negLeft = Integer.MAX_VALUE;
                negRight = Integer.MIN_VALUE;
                posLeft = Integer.MAX_VALUE;
                posRight = Integer.MIN_VALUE;
                break;
            }
            case 1: {
                posLeft = input.readVInt();
                posRight = Math.toIntExact(input.readVLong() + (long)posLeft);
                negLeft = Integer.MAX_VALUE;
                negRight = Integer.MIN_VALUE;
                break;
            }
            case 2: {
                negRight = -input.readVInt();
                negLeft = Math.toIntExact((long)negRight - input.readVLong());
                posLeft = Integer.MAX_VALUE;
                posRight = Integer.MIN_VALUE;
                break;
            }
            case 3: {
                posRight = input.readVInt();
                negLeft = -input.readVInt();
                posLeft = 0;
                negRight = 0;
                break;
            }
            case 4: {
                posLeft = input.readVInt();
                posRight = Math.toIntExact(input.readVLong() + (long)posLeft);
                negRight = -input.readVInt();
                negLeft = Math.toIntExact((long)negRight - input.readVLong());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid extent values-set byte read [" + type + "]");
            }
        }
        extent.reset(top, bottom, negLeft, negRight, posLeft, posRight);
    }

    void writeCompressed(StreamOutput output) throws IOException {
        output.writeInt(this.top);
        output.writeVLong((long)this.top - (long)this.bottom);
        byte type = this.negLeft == Integer.MAX_VALUE && this.negRight == Integer.MIN_VALUE ? (this.posLeft == Integer.MAX_VALUE && this.posRight == Integer.MIN_VALUE ? (byte)0 : 1) : (this.posLeft == Integer.MAX_VALUE && this.posRight == Integer.MIN_VALUE ? (byte)2 : (this.posLeft == 0 && this.negRight == 0 ? (byte)3 : 4));
        output.writeByte(type);
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                output.writeVInt(this.posLeft);
                output.writeVLong((long)this.posRight - (long)this.posLeft);
                break;
            }
            case 2: {
                output.writeVInt(-this.negRight);
                output.writeVLong((long)this.negRight - (long)this.negLeft);
                break;
            }
            case 3: {
                output.writeVInt(this.posRight);
                output.writeVInt(-this.negLeft);
                break;
            }
            case 4: {
                output.writeVInt(this.posLeft);
                output.writeVLong((long)this.posRight - (long)this.posLeft);
                output.writeVInt(-this.negRight);
                output.writeVLong((long)this.negRight - (long)this.negLeft);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid extent values-set byte read [" + type + "]");
            }
        }
    }

    public static Extent fromPoint(int x, int y) {
        return new Extent(y, y, x < 0 ? x : Integer.MAX_VALUE, x < 0 ? x : Integer.MIN_VALUE, x >= 0 ? x : Integer.MAX_VALUE, x >= 0 ? x : Integer.MIN_VALUE);
    }

    static Extent fromPoints(int bottomLeftX, int bottomLeftY, int topRightX, int topRightY) {
        int negLeft = Integer.MAX_VALUE;
        int negRight = Integer.MIN_VALUE;
        int posLeft = Integer.MAX_VALUE;
        int posRight = Integer.MIN_VALUE;
        if (bottomLeftX < 0 && topRightX < 0) {
            negLeft = bottomLeftX;
            negRight = topRightX;
        } else if (bottomLeftX < 0) {
            negLeft = bottomLeftX;
            posRight = topRightX;
            negRight = 0;
            posLeft = 0;
        } else {
            posLeft = bottomLeftX;
            posRight = topRightX;
        }
        return new Extent(topRightY, bottomLeftY, negLeft, negRight, posLeft, posRight);
    }

    public int minY() {
        return this.bottom;
    }

    public int maxY() {
        return this.top;
    }

    public int minX() {
        return Math.min(this.negLeft, this.posLeft);
    }

    public int maxX() {
        return Math.max(this.negRight, this.posRight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extent extent = (Extent)o;
        return this.top == extent.top && this.bottom == extent.bottom && this.negLeft == extent.negLeft && this.negRight == extent.negRight && this.posLeft == extent.posLeft && this.posRight == extent.posRight;
    }

    public int hashCode() {
        return Objects.hash(this.top, this.bottom, this.negLeft, this.negRight, this.posLeft, this.posRight);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("top = " + this.top + ", ");
        builder.append("bottom = " + this.bottom + ", ");
        builder.append("negLeft = " + this.negLeft + ", ");
        builder.append("negRight = " + this.negRight + ", ");
        builder.append("posLeft = " + this.posLeft + ", ");
        builder.append("posRight = " + this.posRight + "]");
        return builder.toString();
    }
}

