/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;

public class ProjectExec
extends UnaryExec
implements Unexecutable {
    private final List<? extends NamedExpression> projections;

    public ProjectExec(Source source, PhysicalPlan child, List<? extends NamedExpression> projections) {
        super(source, child);
        this.projections = projections;
    }

    protected NodeInfo<ProjectExec> info() {
        return NodeInfo.create((Node)this, ProjectExec::new, (Object)this.child(), this.projections);
    }

    @Override
    protected ProjectExec replaceChild(PhysicalPlan newChild) {
        return new ProjectExec(this.source(), newChild, this.projections);
    }

    public List<? extends NamedExpression> projections() {
        return this.projections;
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.projections);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projections, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectExec other = (ProjectExec)obj;
        return Objects.equals(this.projections, other.projections) && Objects.equals(this.child(), other.child());
    }
}

