/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.type.Schema;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggRowSet;
import org.elasticsearch.xpack.sql.execution.search.Querier;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;

public class CompositeAggCursor
implements Cursor {
    private static final Logger log = LogManager.getLogger(CompositeAggCursor.class);
    public static final String NAME = "c";
    private final String[] indices;
    private final byte[] nextQuery;
    private final List<BucketExtractor> extractors;
    private final BitSet mask;
    private final int limit;
    private final boolean includeFrozen;

    CompositeAggCursor(byte[] next, List<BucketExtractor> exts, BitSet mask, int remainingLimit, boolean includeFrozen, String ... indices) {
        this.indices = indices;
        this.nextQuery = next;
        this.extractors = exts;
        this.mask = mask;
        this.limit = remainingLimit;
        this.includeFrozen = includeFrozen;
    }

    public CompositeAggCursor(StreamInput in) throws IOException {
        this.indices = in.readStringArray();
        this.nextQuery = in.readByteArray();
        this.limit = in.readVInt();
        this.extractors = in.readNamedWriteableList(BucketExtractor.class);
        this.mask = BitSet.valueOf(in.readByteArray());
        this.includeFrozen = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        out.writeByteArray(this.nextQuery);
        out.writeVInt(this.limit);
        out.writeNamedWriteableList(this.extractors);
        out.writeByteArray(this.mask.toByteArray());
        out.writeBoolean(this.includeFrozen);
    }

    public String getWriteableName() {
        return NAME;
    }

    String[] indices() {
        return this.indices;
    }

    byte[] next() {
        return this.nextQuery;
    }

    BitSet mask() {
        return this.mask;
    }

    List<BucketExtractor> extractors() {
        return this.extractors;
    }

    int limit() {
        return this.limit;
    }

    boolean includeFrozen() {
        return this.includeFrozen;
    }

    @Override
    public void nextPage(SqlConfiguration cfg, final Client client, NamedWriteableRegistry registry, ActionListener<Cursor.Page> listener) {
        SearchSourceBuilder q;
        try {
            q = CompositeAggCursor.deserializeQuery(registry, this.nextQuery);
        }
        catch (Exception ex) {
            listener.onFailure(ex);
            return;
        }
        SearchSourceBuilder query = q;
        if (log.isTraceEnabled()) {
            log.trace("About to execute composite query {} on {}", (Object)StringUtils.toString((SearchSourceBuilder)query), (Object)this.indices);
        }
        final SearchRequest request = Querier.prepareRequest(query, cfg.requestTimeout(), this.includeFrozen, this.indices);
        client.search(request, (ActionListener)new ActionListener.Delegating<SearchResponse, Cursor.Page>(listener){

            public void onResponse(SearchResponse response) {
                CompositeAggCursor.handle(response, request.source(), CompositeAggCursor.this.makeRowSet(response), CompositeAggCursor.this.makeCursor(), () -> client.search(request, (ActionListener)this), (ActionListener<Cursor.Page>)this.delegate, Schema.EMPTY);
            }
        });
    }

    protected Supplier<CompositeAggRowSet> makeRowSet(SearchResponse response) {
        return () -> new CompositeAggRowSet(this.extractors, this.mask, response, this.limit);
    }

    protected BiFunction<byte[], CompositeAggRowSet, CompositeAggCursor> makeCursor() {
        return (q, r) -> new CompositeAggCursor((byte[])q, r.extractors(), r.mask(), r.remainingData(), this.includeFrozen, this.indices);
    }

    static void handle(SearchResponse response, SearchSourceBuilder source, Supplier<CompositeAggRowSet> makeRowSet, BiFunction<byte[], CompositeAggRowSet, CompositeAggCursor> makeCursor, Runnable retry, ActionListener<Cursor.Page> listener, Schema schema) {
        if (log.isTraceEnabled()) {
            Querier.logSearchResponse(response, log);
        }
        if (!response.getAggregations().asList().isEmpty()) {
            if (CompositeAggCursor.shouldRetryDueToEmptyPage(response)) {
                CompositeAggCursor.updateCompositeAfterKey(response, source);
                retry.run();
                return;
            }
            try {
                CompositeAggRowSet rowSet = makeRowSet.get();
                Map<String, Object> afterKey = rowSet.afterKey();
                byte[] queryAsBytes = null;
                if (afterKey != null) {
                    CompositeAggCursor.updateSourceAfterKey(afterKey, source);
                    queryAsBytes = CompositeAggCursor.serializeQuery(source);
                }
                Cursor next = rowSet.remainingData() == 0 ? Cursor.EMPTY : (Cursor)makeCursor.apply(queryAsBytes, rowSet);
                listener.onResponse((Object)new Cursor.Page(rowSet, next));
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        } else {
            listener.onResponse((Object)Cursor.Page.last(Rows.empty(schema)));
        }
    }

    private static boolean shouldRetryDueToEmptyPage(SearchResponse response) {
        CompositeAggregation composite = CompositeAggCursor.getComposite(response);
        return composite != null && composite.getBuckets().isEmpty() && composite.afterKey() != null && !composite.afterKey().isEmpty();
    }

    static CompositeAggregation getComposite(SearchResponse response) {
        Aggregation agg = response.getAggregations().get("groupby");
        if (agg == null) {
            return null;
        }
        if (agg instanceof CompositeAggregation) {
            return (CompositeAggregation)agg;
        }
        throw new SqlIllegalArgumentException("Unrecognized root group found; {}", agg.getClass());
    }

    private static void updateCompositeAfterKey(SearchResponse r, SearchSourceBuilder search) {
        CompositeAggregation composite = CompositeAggCursor.getComposite(r);
        if (composite == null) {
            throw new SqlIllegalArgumentException("Invalid server response; no group-by detected");
        }
        CompositeAggCursor.updateSourceAfterKey(composite.afterKey(), search);
    }

    private static void updateSourceAfterKey(Map<String, Object> afterKey, SearchSourceBuilder search) {
        AggregationBuilder aggBuilder = (AggregationBuilder)search.aggregations().getAggregatorFactories().iterator().next();
        if (!(aggBuilder instanceof CompositeAggregationBuilder)) {
            throw new SqlIllegalArgumentException("Invalid client request; expected a group-by but instead got {}", aggBuilder);
        }
        CompositeAggregationBuilder comp = (CompositeAggregationBuilder)aggBuilder;
        comp.aggregateAfter(afterKey);
    }

    private static SearchSourceBuilder deserializeQuery(NamedWriteableRegistry registry, byte[] source) throws IOException {
        try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(StreamInput.wrap((byte[])source), registry);){
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder((StreamInput)in);
            return searchSourceBuilder;
        }
    }

    private static byte[] serializeQuery(SearchSourceBuilder source) throws IOException {
        if (source == null) {
            return new byte[0];
        }
        try (BytesStreamOutput out = new BytesStreamOutput();){
            source.writeTo((StreamOutput)out);
            byte[] byArray = BytesReference.toBytes((BytesReference)out.bytes());
            return byArray;
        }
    }

    @Override
    public void clear(Client client, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), Arrays.hashCode(this.nextQuery), this.extractors, this.limit, this.mask, this.includeFrozen);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompositeAggCursor other = (CompositeAggCursor)obj;
        return Arrays.equals(this.indices, other.indices) && Arrays.equals(this.nextQuery, other.nextQuery) && Objects.equals(this.extractors, other.extractors) && Objects.equals(this.limit, other.limit) && Objects.equals(this.includeFrozen, other.includeFrozen);
    }

    public String toString() {
        return "cursor for composite on index [" + Arrays.toString(this.indices) + "]";
    }
}

