/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.io.IOException;
import java.util.function.Consumer;
import org.elasticsearch.nio.Config;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioChannelHandler;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.SocketChannelContext;

public class BytesChannelContext
extends SocketChannelContext {
    public BytesChannelContext(NioSocketChannel channel, NioSelector selector, Config.Socket socketConfig, Consumer<Exception> exceptionHandler, NioChannelHandler handler, InboundChannelBuffer channelBuffer) {
        super(channel, selector, socketConfig, exceptionHandler, handler, channelBuffer);
    }

    @Override
    public int read() throws IOException {
        int bytesRead = this.readFromChannel(this.channelBuffer);
        if (bytesRead == 0) {
            return 0;
        }
        this.handleReadBytes();
        return bytesRead;
    }

    @Override
    public void flushChannel() throws IOException {
        FlushOperation flushOperation;
        this.getSelector().assertOnSelectorThread();
        boolean lastOpCompleted = true;
        while (lastOpCompleted && (flushOperation = this.getPendingFlush()) != null) {
            try {
                if (this.singleFlush(flushOperation)) {
                    this.currentFlushOperationComplete();
                    continue;
                }
                lastOpCompleted = false;
            }
            catch (IOException e) {
                this.currentFlushOperationFailed(e);
                throw e;
            }
        }
    }

    @Override
    public void closeChannel() {
        if (this.isClosing.compareAndSet(false, true)) {
            this.getSelector().queueChannelClose(this.channel);
        }
    }

    @Override
    public boolean selectorShouldClose() {
        return this.closeNow() || this.isClosing.get();
    }

    private boolean singleFlush(FlushOperation flushOperation) throws IOException {
        this.flushToChannel(flushOperation);
        return flushOperation.isFullyFlushed();
    }
}

