/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.index.RestrictedIndicesNames;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.support.StringMatcher;

public final class IndicesPermission {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IndicesPermission.class);
    public static final IndicesPermission NONE = new IndicesPermission(new Group[0]);
    private static final Set<String> PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("create", "create_doc", "index", "write")));
    private final Map<String, Predicate<IndexAbstraction>> allowedIndicesMatchersForAction = new ConcurrentHashMap<String, Predicate<IndexAbstraction>>();
    private final Group[] groups;
    private final boolean hasFieldOrDocumentLevelSecurity;

    public IndicesPermission(Group ... groups) {
        this.groups = groups;
        this.hasFieldOrDocumentLevelSecurity = Arrays.stream(groups).noneMatch(Group::isTotal) && Arrays.stream(groups).anyMatch(g -> g.hasQuery() || ((Group)g).fieldPermissions.hasFieldLevelSecurity());
    }

    private static StringMatcher indexMatcher(Collection<String> ordinaryIndices, Collection<String> restrictedIndices) {
        Predicate<String> matcher;
        if (ordinaryIndices.isEmpty()) {
            matcher = StringMatcher.of(restrictedIndices);
        } else {
            matcher = StringMatcher.of(ordinaryIndices).and("<not-restricted>", index -> false == RestrictedIndicesNames.isRestricted(index));
            if (!restrictedIndices.isEmpty()) {
                matcher = StringMatcher.of(restrictedIndices).or(matcher);
            }
        }
        return matcher;
    }

    public Group[] groups() {
        return this.groups;
    }

    public Predicate<IndexAbstraction> allowedIndicesMatcher(String action) {
        return this.allowedIndicesMatchersForAction.computeIfAbsent(action, a -> Group.buildIndexMatcherPredicateForAction(a, this.groups));
    }

    public boolean hasFieldOrDocumentLevelSecurity() {
        return this.hasFieldOrDocumentLevelSecurity;
    }

    public boolean check(String action) {
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (Group group : this.groups) {
            if (!group.checkAction(action) && (!isMappingUpdateAction || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group))) continue;
            return true;
        }
        return false;
    }

    public ResourcePrivilegesMap checkResourcePrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges) {
        ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder = ResourcePrivilegesMap.builder();
        HashMap<Group, Automaton> predicateCache = new HashMap<Group, Automaton>();
        for (String forIndexPattern : checkForIndexPatterns) {
            Automaton checkIndexAutomaton = Automatons.patterns(forIndexPattern);
            if (!allowRestrictedIndices && !this.isConcreteRestrictedIndex(forIndexPattern)) {
                checkIndexAutomaton = Automatons.minusAndMinimize(checkIndexAutomaton, RestrictedIndicesNames.NAMES_AUTOMATON);
            }
            if (!Operations.isEmpty((Automaton)checkIndexAutomaton)) {
                Automaton allowedIndexPrivilegesAutomaton = null;
                for (Group group : this.groups) {
                    Automaton groupIndexAutomaton = predicateCache.computeIfAbsent(group, g -> Group.buildIndexMatcherAutomaton(g.allowRestrictedIndices(), g.indices()));
                    if (!Operations.subsetOf((Automaton)checkIndexAutomaton, (Automaton)groupIndexAutomaton)) continue;
                    allowedIndexPrivilegesAutomaton = allowedIndexPrivilegesAutomaton != null ? Automatons.unionAndMinimize(Arrays.asList(allowedIndexPrivilegesAutomaton, group.privilege().getAutomaton())) : group.privilege().getAutomaton();
                }
                for (String privilege : checkForPrivileges) {
                    IndexPrivilege indexPrivilege = IndexPrivilege.get(Collections.singleton(privilege));
                    if (allowedIndexPrivilegesAutomaton != null && Operations.subsetOf((Automaton)indexPrivilege.getAutomaton(), (Automaton)allowedIndexPrivilegesAutomaton)) {
                        resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.TRUE);
                        continue;
                    }
                    resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
                }
                continue;
            }
            for (String privilege : checkForPrivileges) {
                resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
            }
        }
        return resourcePrivilegesMapBuilder.build();
    }

    public Automaton allowedActionsMatcher(String index) {
        ArrayList<Automaton> automatonList = new ArrayList<Automaton>();
        for (Group group : this.groups) {
            if (!group.indexNameMatcher.test(index)) continue;
            automatonList.add(group.privilege.getAutomaton());
        }
        return automatonList.isEmpty() ? Automatons.EMPTY : Automatons.unionAndMinimize(automatonList);
    }

    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, IndexAbstraction> lookup, FieldPermissionsCache fieldPermissionsCache) {
        if (Arrays.stream(this.groups).anyMatch(Group::isTotal)) {
            return IndicesAccessControl.allowAll();
        }
        ArrayList<IndexResource> resources = new ArrayList<IndexResource>(requestedIndicesOrAliases.size());
        int totalResourceCount = 0;
        for (String indexOrAlias : requestedIndicesOrAliases) {
            IndexResource resource = new IndexResource(indexOrAlias, lookup.get(indexOrAlias));
            resources.add(resource);
            totalResourceCount += resource.size();
        }
        HashMap<String, Set> fieldPermissionsByIndex = new HashMap<String, Set>(totalResourceCount);
        HashMap<String, DocumentLevelPermissions> roleQueriesByIndex = new HashMap<String, DocumentLevelPermissions>(totalResourceCount);
        HashMap<String, Boolean> grantedBuilder = new HashMap<String, Boolean>(totalResourceCount);
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (IndexResource resource : resources) {
            boolean granted = false;
            boolean bwcGrantMappingUpdate = false;
            ArrayList<Runnable> bwcDeprecationLogActions = new ArrayList<Runnable>();
            Collection<String> concreteIndices = resource.resolveConcreteIndices();
            for (Group group : this.groups) {
                if (!resource.checkIndex(group)) continue;
                boolean actionCheck = group.checkAction(action);
                granted = granted || actionCheck;
                boolean bwcMappingActionCheck = isMappingUpdateAction && false == resource.isPartOfDataStream() && IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group);
                boolean bl = bwcGrantMappingUpdate = bwcGrantMappingUpdate || bwcMappingActionCheck;
                if (!actionCheck && !bwcMappingActionCheck) continue;
                for (String index : concreteIndices) {
                    DocumentLevelPermissions docPermissions;
                    Set fieldPermissions = fieldPermissionsByIndex.compute(index, (k, existingSet) -> {
                        if (existingSet == null) {
                            return org.elasticsearch.core.Set.of((Object)group.getFieldPermissions());
                        }
                        if (existingSet.size() == 1) {
                            FieldPermissions fp = group.getFieldPermissions();
                            if (existingSet.contains(fp)) {
                                return existingSet;
                            }
                            HashSet<FieldPermissions> hashSet = new HashSet<FieldPermissions>((Collection<FieldPermissions>)existingSet);
                            hashSet.add(fp);
                            return hashSet;
                        }
                        existingSet.add(group.getFieldPermissions());
                        return existingSet;
                    });
                    if (group.hasQuery()) {
                        docPermissions = roleQueriesByIndex.computeIfAbsent(index, k -> new DocumentLevelPermissions());
                        docPermissions.addAll(group.getQuery());
                    } else {
                        docPermissions = DocumentLevelPermissions.ALLOW_ALL;
                        roleQueriesByIndex.put(index, docPermissions);
                    }
                    if (index.equals(resource.name)) continue;
                    fieldPermissionsByIndex.put(resource.name, fieldPermissions);
                    roleQueriesByIndex.put(resource.name, docPermissions);
                }
                if (actionCheck) continue;
                for (String privilegeName : group.privilege.name()) {
                    if (!PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE.contains(privilegeName)) continue;
                    bwcDeprecationLogActions.add(() -> deprecationLogger.warn(DeprecationCategory.SECURITY, "[" + resource.name + "] mapping update for ingest privilege [" + privilegeName + "]", "the index privilege [" + privilegeName + "] allowed the update mapping action [" + action + "] on index [" + resource.name + "], this privilege will not permit mapping updates in the next major release - users who require access to update mappings must be granted explicit privileges", new Object[0]));
                }
            }
            if (!granted && bwcGrantMappingUpdate) {
                granted = true;
                bwcDeprecationLogActions.forEach(deprecationLogAction -> deprecationLogAction.run());
            }
            grantedBuilder.put(resource.name, granted);
            if (!resource.canHaveBackingIndices()) continue;
            for (String concreteIndex : concreteIndices) {
                if (requestedIndicesOrAliases.contains(concreteIndex)) continue;
                grantedBuilder.merge(concreteIndex, granted, Boolean::logicalOr);
            }
        }
        boolean overallGranted = true;
        HashMap<String, IndicesAccessControl.IndexAccessControl> indexPermissions = new HashMap<String, IndicesAccessControl.IndexAccessControl>(grantedBuilder.size());
        for (Map.Entry entry : grantedBuilder.entrySet()) {
            String index = (String)entry.getKey();
            DocumentLevelPermissions permissions = (DocumentLevelPermissions)roleQueriesByIndex.get(index);
            Set<BytesReference> roleQueries = permissions != null && !permissions.isAllowAll() ? Collections.unmodifiableSet(permissions.queries) : null;
            Set indexFieldPermissions = (Set)fieldPermissionsByIndex.get(index);
            FieldPermissions fieldPermissions = indexFieldPermissions != null && !indexFieldPermissions.isEmpty() ? (indexFieldPermissions.size() == 1 ? (FieldPermissions)indexFieldPermissions.iterator().next() : fieldPermissionsCache.getFieldPermissions(indexFieldPermissions)) : FieldPermissions.DEFAULT;
            if (!((Boolean)entry.getValue()).booleanValue()) {
                overallGranted = false;
            }
            indexPermissions.put(index, new IndicesAccessControl.IndexAccessControl((Boolean)entry.getValue(), fieldPermissions, roleQueries != null ? DocumentPermissions.filteredBy(roleQueries) : DocumentPermissions.allowAll()));
        }
        return new IndicesAccessControl(overallGranted, Collections.unmodifiableMap(indexPermissions));
    }

    private boolean isConcreteRestrictedIndex(String indexPattern) {
        if (Regex.isSimpleMatchPattern((String)indexPattern) || Automatons.isLuceneRegex(indexPattern)) {
            return false;
        }
        return RestrictedIndicesNames.isRestricted(indexPattern);
    }

    private static boolean isMappingUpdateAction(String action) {
        return action.equals("indices:admin/mapping/put") || action.equals("indices:admin/mapping/auto_put");
    }

    private static boolean containsPrivilegeThatGrantsMappingUpdatesForBwc(Group group) {
        return group.privilege().name().stream().anyMatch(PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE::contains);
    }

    public static class Group {
        private final IndexPrivilege privilege;
        private final Predicate<String> actionMatcher;
        private final String[] indices;
        private final StringMatcher indexNameMatcher;
        private final FieldPermissions fieldPermissions;
        private final Set<BytesReference> query;
        private final boolean allowRestrictedIndices;

        public Group(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, String ... indices) {
            assert (indices.length != 0);
            this.privilege = privilege;
            this.actionMatcher = privilege.predicate();
            this.indices = indices;
            this.indexNameMatcher = StringMatcher.of(Arrays.asList(indices));
            this.fieldPermissions = Objects.requireNonNull(fieldPermissions);
            this.query = query;
            this.allowRestrictedIndices = allowRestrictedIndices;
        }

        public IndexPrivilege privilege() {
            return this.privilege;
        }

        public String[] indices() {
            return this.indices;
        }

        @Nullable
        public Set<BytesReference> getQuery() {
            return this.query;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        private boolean checkAction(String action) {
            return this.actionMatcher.test(action);
        }

        private boolean checkIndex(String index) {
            assert (index != null);
            return this.indexNameMatcher.test(index) && (this.allowRestrictedIndices || false == RestrictedIndicesNames.isRestricted(index));
        }

        boolean hasQuery() {
            return this.query != null;
        }

        public boolean allowRestrictedIndices() {
            return this.allowRestrictedIndices;
        }

        public static Automaton buildIndexMatcherAutomaton(boolean allowRestrictedIndices, String ... indices) {
            Automaton indicesAutomaton = Automatons.patterns(indices);
            if (allowRestrictedIndices) {
                return indicesAutomaton;
            }
            return Automatons.minusAndMinimize(indicesAutomaton, RestrictedIndicesNames.NAMES_AUTOMATON);
        }

        private static Predicate<IndexAbstraction> buildIndexMatcherPredicateForAction(String action, Group ... groups) {
            HashSet<String> ordinaryIndices = new HashSet<String>();
            HashSet<String> restrictedIndices = new HashSet<String>();
            HashSet<String> grantMappingUpdatesOnIndices = new HashSet<String>();
            HashSet<String> grantMappingUpdatesOnRestrictedIndices = new HashSet<String>();
            boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
            for (Group group : groups) {
                if (group.actionMatcher.test(action)) {
                    if (group.allowRestrictedIndices) {
                        restrictedIndices.addAll(Arrays.asList(group.indices()));
                        continue;
                    }
                    ordinaryIndices.addAll(Arrays.asList(group.indices()));
                    continue;
                }
                if (!isMappingUpdateAction || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group)) continue;
                if (group.allowRestrictedIndices) {
                    grantMappingUpdatesOnRestrictedIndices.addAll(Arrays.asList(group.indices()));
                    continue;
                }
                grantMappingUpdatesOnIndices.addAll(Arrays.asList(group.indices()));
            }
            StringMatcher nameMatcher = IndicesPermission.indexMatcher(ordinaryIndices, restrictedIndices);
            StringMatcher bwcSpecialCaseMatcher = IndicesPermission.indexMatcher(grantMappingUpdatesOnIndices, grantMappingUpdatesOnRestrictedIndices);
            return indexAbstraction -> nameMatcher.test(indexAbstraction.getName()) || indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM && indexAbstraction.getParentDataStream() == null && bwcSpecialCaseMatcher.test(indexAbstraction.getName());
        }

        boolean isTotal() {
            return this.allowRestrictedIndices && this.indexNameMatcher.isTotal() && this.privilege == IndexPrivilege.ALL && this.query == null && false == this.fieldPermissions.hasFieldLevelSecurity();
        }
    }

    private static class IndexResource {
        private final String name;
        @Nullable
        private final IndexAbstraction indexAbstraction;
        public Collection<String> concreteIndices;

        private IndexResource(String name, @Nullable IndexAbstraction abstraction) {
            assert (name != null) : "Resource name cannot be null";
            assert (abstraction == null || abstraction.getName().equals(name)) : "Index abstraction has unexpected name [" + abstraction.getName() + "] vs [" + name + "]";
            this.name = name;
            this.indexAbstraction = abstraction;
        }

        public boolean isPartOfDataStream() {
            if (this.indexAbstraction == null) {
                return false;
            }
            switch (this.indexAbstraction.getType()) {
                case DATA_STREAM: {
                    return true;
                }
                case CONCRETE_INDEX: {
                    return this.indexAbstraction.getParentDataStream() != null;
                }
            }
            return false;
        }

        public boolean checkIndex(Group group) {
            IndexAbstraction.DataStream ds;
            IndexAbstraction.DataStream dataStream = ds = this.indexAbstraction == null ? null : this.indexAbstraction.getParentDataStream();
            if (ds != null && group.checkIndex(ds.getName())) {
                return true;
            }
            return group.checkIndex(this.name);
        }

        public int size() {
            if (this.indexAbstraction == null) {
                return 1;
            }
            if (this.indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX) {
                return 1;
            }
            return 1 + this.indexAbstraction.getIndices().size();
        }

        public Collection<String> resolveConcreteIndices() {
            if (this.indexAbstraction == null) {
                return org.elasticsearch.core.List.of();
            }
            if (this.indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX) {
                return org.elasticsearch.core.List.of((Object)this.indexAbstraction.getName());
            }
            List indices = this.indexAbstraction.getIndices();
            ArrayList<String> concreteIndexNames = new ArrayList<String>(indices.size());
            for (Index idx : indices) {
                concreteIndexNames.add(idx.getName());
            }
            return concreteIndexNames;
        }

        public boolean canHaveBackingIndices() {
            return this.indexAbstraction != null && this.indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX;
        }
    }

    private static class DocumentLevelPermissions {
        public static final DocumentLevelPermissions ALLOW_ALL = new DocumentLevelPermissions();
        private Set<BytesReference> queries = null;
        private boolean allowAll = false;

        private DocumentLevelPermissions() {
        }

        private void addAll(Set<BytesReference> query) {
            if (!this.allowAll) {
                if (this.queries == null) {
                    this.queries = new HashSet<BytesReference>(query.size());
                }
                this.queries.addAll(query);
            }
        }

        private boolean isAllowAll() {
            return this.allowAll;
        }

        static {
            DocumentLevelPermissions.ALLOW_ALL.allowAll = true;
        }
    }
}

