/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.action.NodeAcknowledgedResponse;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlTaskParams;

public class StartDatafeedAction
extends ActionType<NodeAcknowledgedResponse> {
    public static final ParseField START_TIME = new ParseField("start", new String[0]);
    public static final ParseField END_TIME = new ParseField("end", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final StartDatafeedAction INSTANCE = new StartDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeed/start";

    private StartDatafeedAction() {
        super(NAME, NodeAcknowledgedResponse::new);
    }

    public static interface DatafeedTaskMatcher {
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, NodeAcknowledgedResponse> {
        RequestBuilder(ElasticsearchClient client, StartDatafeedAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class DatafeedParams
    implements XPackPlugin.XPackPersistentTaskParams,
    MlTaskParams {
        public static final ParseField INDICES = new ParseField("indices", new String[0]);
        public static final ObjectParser<DatafeedParams, Void> PARSER = new ObjectParser("xpack/ml/datafeed", true, DatafeedParams::new);
        private String datafeedId;
        private long startTime;
        private Long endTime;
        private TimeValue timeout = TimeValue.timeValueSeconds((long)20L);
        private List<String> datafeedIndices = Collections.emptyList();
        private String jobId;
        private IndicesOptions indicesOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;

        static long parseDateOrThrow(String date, ParseField paramName, LongSupplier now) {
            DateMathParser dateMathParser = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.toDateMathParser();
            try {
                return dateMathParser.parse(date, now).toEpochMilli();
            }
            catch (Exception e) {
                String msg = Messages.getMessage("Query param [{0}] with value [{1}] cannot be parsed as a date or converted to a number (epoch).", paramName.getPreferredName(), date);
                throw new ElasticsearchParseException(msg, (Throwable)e, new Object[0]);
            }
        }

        public static DatafeedParams fromXContent(XContentParser parser) {
            return DatafeedParams.parseRequest(null, parser);
        }

        public static DatafeedParams parseRequest(String datafeedId, XContentParser parser) {
            DatafeedParams params = (DatafeedParams)PARSER.apply(parser, null);
            if (datafeedId != null) {
                params.datafeedId = datafeedId;
            }
            return params;
        }

        public DatafeedParams(String datafeedId, long startTime) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
            this.startTime = startTime;
        }

        public DatafeedParams(String datafeedId, String startTime) {
            this(datafeedId, DatafeedParams.parseDateOrThrow(startTime, START_TIME, System::currentTimeMillis));
        }

        public DatafeedParams(StreamInput in) throws IOException {
            this.datafeedId = in.readString();
            this.startTime = in.readVLong();
            this.endTime = in.readOptionalLong();
            this.timeout = TimeValue.timeValueMillis((long)in.readVLong());
            if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
                this.jobId = in.readOptionalString();
                this.datafeedIndices = in.readStringList();
            }
            this.indicesOptions = in.getVersion().onOrAfter(Version.V_7_7_0) ? IndicesOptions.readIndicesOptions((StreamInput)in) : SearchRequest.DEFAULT_INDICES_OPTIONS;
        }

        DatafeedParams() {
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.setEndTime(DatafeedParams.parseDateOrThrow(endTime, END_TIME, System::currentTimeMillis));
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public List<String> getDatafeedIndices() {
            return this.datafeedIndices;
        }

        public void setDatafeedIndices(List<String> datafeedIndices) {
            this.datafeedIndices = datafeedIndices;
        }

        public IndicesOptions getIndicesOptions() {
            return this.indicesOptions;
        }

        public DatafeedParams setIndicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = ExceptionsHelper.requireNonNull(indicesOptions, DatafeedConfig.INDICES_OPTIONS);
            return this;
        }

        public String getWriteableName() {
            return "xpack/ml/datafeed";
        }

        public Version getMinimalSupportedVersion() {
            return Version.CURRENT.minimumCompatibilityVersion();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.datafeedId);
            out.writeVLong(this.startTime);
            out.writeOptionalLong(this.endTime);
            out.writeVLong(this.timeout.millis());
            if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
                out.writeOptionalString(this.jobId);
                out.writeStringCollection(this.datafeedIndices);
            }
            if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
                this.indicesOptions.writeIndicesOptions(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            builder.field(START_TIME.getPreferredName(), String.valueOf(this.startTime));
            if (this.endTime != null) {
                builder.field(END_TIME.getPreferredName(), String.valueOf(this.endTime));
            }
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            if (this.jobId != null) {
                builder.field(Job.ID.getPreferredName(), this.jobId);
            }
            if (!this.datafeedIndices.isEmpty()) {
                builder.field(INDICES.getPreferredName(), this.datafeedIndices);
            }
            builder.startObject(DatafeedConfig.INDICES_OPTIONS.getPreferredName());
            this.indicesOptions.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.startTime, this.endTime, this.timeout, this.jobId, this.datafeedIndices, this.indicesOptions);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DatafeedParams other = (DatafeedParams)obj;
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.indicesOptions, other.indicesOptions) && Objects.equals(this.datafeedIndices, other.datafeedIndices);
        }

        @Override
        public String getMlId() {
            return this.datafeedId;
        }

        static {
            PARSER.declareString((params, datafeedId) -> {
                params.datafeedId = datafeedId;
            }, DatafeedConfig.ID);
            PARSER.declareString((params, startTime) -> {
                params.startTime = DatafeedParams.parseDateOrThrow(startTime, START_TIME, System::currentTimeMillis);
            }, START_TIME);
            PARSER.declareString(DatafeedParams::setEndTime, END_TIME);
            PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareString(DatafeedParams::setJobId, Job.ID);
            PARSER.declareStringArray(DatafeedParams::setDatafeedIndices, INDICES);
            PARSER.declareObject(DatafeedParams::setIndicesOptions, (p, c) -> IndicesOptions.fromMap((Map)p.map(), (IndicesOptions)SearchRequest.DEFAULT_INDICES_OPTIONS), DatafeedConfig.INDICES_OPTIONS);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        private DatafeedParams params;

        public static Request fromXContent(XContentParser parser) {
            return Request.parseRequest(null, parser);
        }

        public static Request parseRequest(String datafeedId, XContentParser parser) {
            DatafeedParams params = (DatafeedParams)DatafeedParams.PARSER.apply(parser, null);
            if (datafeedId != null) {
                params.datafeedId = datafeedId;
            }
            return new Request(params);
        }

        public Request(String datafeedId, long startTime) {
            this.params = new DatafeedParams(datafeedId, startTime);
        }

        public Request(String datafeedId, String startTime) {
            this.params = new DatafeedParams(datafeedId, startTime);
        }

        public Request(DatafeedParams params) {
            this.params = params;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.params = new DatafeedParams(in);
        }

        public Request() {
        }

        public DatafeedParams getParams() {
            return this.params;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            if (this.params.endTime != null && this.params.endTime <= this.params.startTime) {
                e = ValidateActions.addValidationError((String)(START_TIME.getPreferredName() + " [" + this.params.startTime + "] must be earlier than " + END_TIME.getPreferredName() + " [" + this.params.endTime + "]"), e);
            }
            return e;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.params.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params xContentParams) throws IOException {
            this.params.toXContent(builder, xContentParams);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.params);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.params, other.params);
        }
    }
}

