/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.joda.JodaDeprecationPatterns;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingSlowLog;
import org.elasticsearch.index.SearchSlowLog;
import org.elasticsearch.index.SlowLogLevel;
import org.elasticsearch.index.engine.frozen.FrozenEngine;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.xpack.cluster.routing.allocation.DataTierAllocationDecider;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.ClusterDeprecationChecks;
import org.elasticsearch.xpack.deprecation.NodeDeprecationChecks;

public class IndexDeprecationChecks {
    private static final Logger logger = LogManager.getLogger(IndexDeprecationChecks.class);
    static final String JODA_TIME_DEPRECATION_DETAILS_SUFFIX = " See https://www.elastic.co/guide/en/elasticsearch/reference/master/migrate-to-java-time.html for details. Failure to update custom data formats to java.time could cause inconsistentencies in your data. Failure to properly convert x (week-year) to Y could result in data loss.";
    private static final Set<String> TYPES_THAT_DONT_COUNT;

    private static void fieldLevelMappingIssue(IndexMetadata indexMetadata, BiConsumer<MappingMetadata, Map<String, Object>> checker) {
        for (MappingMetadata mappingMetadata : indexMetadata.getMappings().values()) {
            Map sourceAsMap = mappingMetadata.sourceAsMap();
            checker.accept(mappingMetadata, sourceAsMap);
        }
    }

    static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate, BiFunction<String, Map.Entry<?, ?>, String> fieldFormatter, String fieldBeginMarker, String fieldEndMarker) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add(fieldBeginMarker + fieldFormatter.apply(type, entry) + fieldEndMarker);
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add(fieldBeginMarker + fieldFormatter.apply(type, entry) + ", multifield: " + multifieldEntry.getKey() + fieldEndMarker);
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, multifieldValueMap, predicate, fieldFormatter, fieldBeginMarker, fieldEndMarker));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, valueMap, predicate, fieldFormatter, fieldBeginMarker, fieldEndMarker));
        }
        return issues;
    }

    static List<String> findInDynamicTemplates(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate, BiFunction<String, Map.Entry<?, ?>, String> fieldFormatter, String fieldBeginMarker, String fieldEndMarker) {
        ArrayList<String> issues = new ArrayList<String>();
        List dynamicTemplates = (List)parentMap.get("dynamic_templates");
        if (dynamicTemplates == null) {
            return issues;
        }
        for (Object entry : dynamicTemplates) {
            Map.Entry templateEntry;
            Map templateBody;
            Map topLevelTemplate = (Map)entry;
            Iterator templateCursor = topLevelTemplate.entrySet().iterator();
            if (!templateCursor.hasNext() || !predicate.apply(templateBody = (Map)(templateEntry = templateCursor.next()).getValue()).booleanValue()) continue;
            issues.add(fieldBeginMarker + fieldFormatter.apply(type, templateEntry) + fieldEndMarker);
        }
        return issues;
    }

    private static String formatDateField(String type, Map.Entry<?, ?> entry) {
        Map value = (Map)entry.getValue();
        return String.format(Locale.ROOT, "Convert [%s] format %s to java.time.", entry.getKey(), value.get("format"));
    }

    static String formatField(String type, Map.Entry<?, ?> entry) {
        return entry.getKey().toString();
    }

    static DeprecationIssue oldIndicesCheck(IndexMetadata indexMetadata) {
        Version createdWith = indexMetadata.getCreationVersion();
        if (createdWith.before(Version.V_7_0_0)) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Index created before 7.0", "https://ela.st/es-deprecation-7-reindex", "This index was created with version " + createdWith + " and is not compatible with 8.0. Reindex or remove the index before upgrading.", false, null);
        }
        return null;
    }

    static DeprecationIssue tooManyFieldsCheck(IndexMetadata indexMetadata) {
        if (indexMetadata.getSettings().get(IndexSettings.DEFAULT_FIELD_SETTING.getKey()) == null) {
            AtomicInteger fieldCount = new AtomicInteger(0);
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> fieldCount.addAndGet(IndexDeprecationChecks.countFieldsRecursively(mappingMetadata.type(), sourceAsMap)));
            if (fieldCount.get() > 1024) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Number of fields exceeds automatic field expansion limit", "https://ela.st/es-deprecation-7-number-of-auto-expanded-fields", "This index has " + fieldCount.get() + " fields, which exceeds the automatic field expansion limit (1024). Set " + IndexSettings.DEFAULT_FIELD_SETTING.getKey() + " to prevent queries that support automatic field expansion from failing if no fields are specified. Otherwise, you must explicitly specify fields in all query_string, simple_query_string, and multi_match queries.", false, null);
            }
        }
        return null;
    }

    static DeprecationIssue deprecatedDateTimeFormat(IndexMetadata indexMetadata) {
        Version createdWith = indexMetadata.getCreationVersion();
        if (createdWith.before(Version.V_7_0_0)) {
            ArrayList fields = new ArrayList();
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> fields.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetadata.type(), sourceAsMap, IndexDeprecationChecks::isDateFieldWithDeprecatedPattern, IndexDeprecationChecks::formatDateField, "", "")));
            if (fields.size() > 0) {
                String detailsMessageBeginning = fields.stream().collect(Collectors.joining(" "));
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Date fields use deprecated Joda time formats", "https://ela.st/es-deprecation-7-java-time", detailsMessageBeginning + JODA_TIME_DEPRECATION_DETAILS_SUFFIX, false, null);
            }
        }
        return null;
    }

    private static boolean isDateFieldWithDeprecatedPattern(Map<?, ?> property) {
        return "date".equals(property.get("type")) && property.containsKey("format") && JodaDeprecationPatterns.isDeprecatedPattern((String)((String)property.get("format")));
    }

    static DeprecationIssue chainedMultiFieldsCheck(IndexMetadata indexMetadata) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetadata.type(), sourceAsMap, IndexDeprecationChecks::containsChainedMultiFields, IndexDeprecationChecks::formatField, "", "")));
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining multi-fields within multi-fields is deprecated", "https://ela.st/es-deprecation-7-chained-multi-fields", String.format(Locale.ROOT, "Remove chained multi-fields from the \"%s\" mapping%s. Multi-fields within multi-fields are not supported in 8.0.", issues.stream().collect(Collectors.joining(",")), issues.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue chainedMultiFieldsDynamicTemplateCheck(IndexMetadata indexMetadata) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> issues.addAll(IndexDeprecationChecks.findInDynamicTemplates(mappingMetadata.type(), sourceAsMap, IndexDeprecationChecks::containsMappingWithChainedMultiFields, IndexDeprecationChecks::formatField, "", "")));
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining multi-fields within multi-fields inside dynamic templates is deprecated", "https://ela.st/es-deprecation-7-chained-multi-fields", String.format(Locale.ROOT, "Remove chained multi-fields from the \"%s\" dynamic template%s. Multi-fields within multi-fields are not supported in 8.0.", issues.stream().collect(Collectors.joining(",")), issues.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static boolean containsMappingWithChainedMultiFields(Map<?, ?> property) {
        if (property.containsKey("mapping")) {
            Map mappings = (Map)property.get("mapping");
            return IndexDeprecationChecks.containsChainedMultiFields(mappings);
        }
        return false;
    }

    static boolean containsChainedMultiFields(Map<?, ?> property) {
        if (property.containsKey("fields")) {
            Map fields = (Map)property.get("fields");
            for (Object rawSubField : fields.values()) {
                Map subField = (Map)rawSubField;
                if (!subField.containsKey("fields")) continue;
                return true;
            }
        }
        return false;
    }

    static DeprecationIssue fieldNamesDisabledCheck(IndexMetadata indexMetadata) {
        MappingMetadata mapping = indexMetadata.mapping();
        if (mapping != null && ClusterDeprecationChecks.mapContainsFieldNamesDisabled(mapping.getSourceAsMap())) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Disabling the \"_field_names\" field in the index mappings is deprecated", "https://ela.st/es-deprecation-7-field_names-settings", "Remove the \"field_names\" mapping that configures the enabled setting. There's no longer a need to disable this field to reduce index overhead if you have a lot of fields.", false, null);
        }
        return null;
    }

    static int countFieldsRecursively(String type, Map<String, Object> parentMap) {
        int fields = 0;
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return fields;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (valueMap.containsKey("type") && !(valueMap.get("type").equals("object") && !valueMap.containsKey("properties")) && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                ++fields;
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (multifieldValueMap.containsKey("type") && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                        ++fields;
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    fields += IndexDeprecationChecks.countFieldsRecursively(type, multifieldValueMap);
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            fields += IndexDeprecationChecks.countFieldsRecursively(type, valueMap);
        }
        return fields;
    }

    static DeprecationIssue translogRetentionSettingCheck(IndexMetadata indexMetadata) {
        boolean softDeletesEnabled = (Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetadata.getSettings());
        if (softDeletesEnabled && (IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexMetadata.getSettings()) || IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexMetadata.getSettings()))) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Translog retention settings are deprecated", "https://ela.st/es-deprecation-7-translog-settings", "Remove the translog retention settings: \"index.translog.retention.size\" and \"index.translog.retention.age\". The translog has not been used in peer recoveries with soft-deletes enabled since 7.0 and these settings have no effect.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkIndexDataPath(IndexMetadata indexMetadata) {
        if (IndexMetadata.INDEX_DATA_PATH_SETTING.exists(indexMetadata.getSettings())) {
            String message = String.format(Locale.ROOT, "Setting [index.data_path] is deprecated", IndexMetadata.INDEX_DATA_PATH_SETTING.getKey());
            String url = "https://ela.st/es-deprecation-7-shared-path-settings";
            String details = String.format(Locale.ROOT, "Remove the [%s] setting. This setting has had no effect since 6.0.", IndexMetadata.INDEX_DATA_PATH_SETTING.getKey());
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, "https://ela.st/es-deprecation-7-shared-path-settings", details, false, null);
        }
        return null;
    }

    static DeprecationIssue indexingSlowLogLevelSettingCheck(IndexMetadata indexMetadata) {
        return IndexDeprecationChecks.slowLogSettingCheck(indexMetadata, (Setting<SlowLogLevel>)IndexingSlowLog.INDEX_INDEXING_SLOWLOG_LEVEL_SETTING);
    }

    static DeprecationIssue searchSlowLogLevelSettingCheck(IndexMetadata indexMetadata) {
        return IndexDeprecationChecks.slowLogSettingCheck(indexMetadata, (Setting<SlowLogLevel>)SearchSlowLog.INDEX_SEARCH_SLOWLOG_LEVEL);
    }

    private static DeprecationIssue slowLogSettingCheck(IndexMetadata indexMetadata, Setting<SlowLogLevel> setting) {
        if (setting.exists(indexMetadata.getSettings())) {
            String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", setting.getKey());
            String url = "https://ela.st/es-deprecation-7-slowlog-settings";
            String details = String.format(Locale.ROOT, "Remove the [%s] setting. Use the [index.*.slowlog.threshold] settings to set the log levels.", setting.getKey());
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, "https://ela.st/es-deprecation-7-slowlog-settings", details, false, null);
        }
        return null;
    }

    static DeprecationIssue storeTypeSettingCheck(IndexMetadata indexMetadata) {
        String storeType = (String)IndexModule.INDEX_STORE_TYPE_SETTING.get(indexMetadata.getSettings());
        if (IndexModule.Type.SIMPLEFS.match(storeType)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Setting [index.store.type] to [simplefs] is deprecated", "https://ela.st/es-deprecation-7-simplefs-store-type", "Use [niofs] (the default) or one of the other FS types. This is an expert-only setting that might be removed in the future.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkRemovedSetting(Settings settings, Setting<?> removedSetting, String url, String additionalDetail, DeprecationIssue.Level deprecationLevel) {
        return IndexDeprecationChecks.checkRemovedSetting(settings, removedSetting, url, "Setting [%s] is deprecated", additionalDetail, deprecationLevel);
    }

    static DeprecationIssue checkRemovedSetting(Settings settings, Setting<?> removedSetting, String url, String messagePattern, String additionalDetail, DeprecationIssue.Level deprecationLevel) {
        if (!removedSetting.exists(settings)) {
            return null;
        }
        String removedSettingKey = removedSetting.getKey();
        String value = removedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, messagePattern, removedSettingKey);
        String details = String.format(Locale.ROOT, "Remove the [%s] setting. %s", removedSettingKey, additionalDetail);
        return new DeprecationIssue(deprecationLevel, message, url, details, false, null);
    }

    static DeprecationIssue checkIndexRoutingRequireSetting(IndexMetadata indexMetadata) {
        return IndexDeprecationChecks.checkRemovedSetting(indexMetadata.getSettings(), DataTierAllocationDecider.INDEX_ROUTING_REQUIRE_SETTING, "https://ela.st/es-deprecation-7-tier-filtering-settings", "Use [index.routing.allocation.include._tier_preference] to control allocation to data tiers.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkIndexRoutingIncludeSetting(IndexMetadata indexMetadata) {
        return IndexDeprecationChecks.checkRemovedSetting(indexMetadata.getSettings(), DataTierAllocationDecider.INDEX_ROUTING_INCLUDE_SETTING, "https://ela.st/es-deprecation-7-tier-filtering-settings", "Use [index.routing.allocation.include._tier_preference] to control allocation to data tiers.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkIndexRoutingExcludeSetting(IndexMetadata indexMetadata) {
        return IndexDeprecationChecks.checkRemovedSetting(indexMetadata.getSettings(), DataTierAllocationDecider.INDEX_ROUTING_EXCLUDE_SETTING, "https://ela.st/es-deprecation-7-tier-filtering-settings", "Use [index.routing.allocation.include._tier_preference] to control allocation to data tiers.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue checkIndexMatrixFiltersSetting(IndexMetadata indexMetadata) {
        return IndexDeprecationChecks.checkRemovedSetting(indexMetadata.getSettings(), IndexSettings.MAX_ADJACENCY_MATRIX_FILTERS_SETTING, "https://ela.st/es-deprecation-7-adjacency-matrix-filters-setting", String.format(Locale.ROOT, "Setting [%s] is deprecated", IndexSettings.MAX_ADJACENCY_MATRIX_FILTERS_SETTING.getKey()), String.format(Locale.ROOT, "Set [%s] to [%s]. [%s] will be ignored in 8.0.", SearchModule.INDICES_MAX_CLAUSE_COUNT_SETTING.getKey(), IndexSettings.MAX_ADJACENCY_MATRIX_FILTERS_SETTING.get(indexMetadata.getSettings()), IndexSettings.MAX_ADJACENCY_MATRIX_FILTERS_SETTING.getKey()), DeprecationIssue.Level.WARNING);
    }

    protected static boolean isGeoShapeFieldWithDeprecatedParam(Map<?, ?> property) {
        return "geo_shape".equals(property.get("type")) && GeoShapeFieldMapper.DEPRECATED_PARAMETERS.stream().anyMatch(deprecatedParameter -> property.containsKey(deprecatedParameter));
    }

    protected static String formatDeprecatedGeoShapeParamMessage(String type, Map.Entry<?, ?> entry) {
        String fieldName = entry.getKey().toString();
        Map value = (Map)entry.getValue();
        return GeoShapeFieldMapper.DEPRECATED_PARAMETERS.stream().filter(deprecatedParameter -> value.containsKey(deprecatedParameter)).map(deprecatedParameter -> String.format(Locale.ROOT, "parameter [%s] in field [%s]", deprecatedParameter, fieldName)).collect(Collectors.joining("; "));
    }

    static DeprecationIssue checkGeoShapeMappings(IndexMetadata indexMetadata) {
        if (indexMetadata == null || indexMetadata.mapping() == null) {
            return null;
        }
        Map sourceAsMap = indexMetadata.mapping().getSourceAsMap();
        List<String> messages = IndexDeprecationChecks.findInPropertiesRecursively("geo_shape", sourceAsMap, IndexDeprecationChecks::isGeoShapeFieldWithDeprecatedParam, IndexDeprecationChecks::formatDeprecatedGeoShapeParamMessage, "[", "]");
        if (messages.isEmpty()) {
            return null;
        }
        String message = String.format(Locale.ROOT, "[%s] index uses deprecated geo_shape properties", indexMetadata.getIndex().getName());
        String details = String.format(Locale.ROOT, "The following geo_shape parameters must be removed from %s: [%s]", indexMetadata.getIndex().getName(), messages.stream().collect(Collectors.joining("; ")));
        String url = "https://ela.st/es-deprecation-7-geo-shape-mappings";
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
    }

    static DeprecationIssue frozenIndexSettingCheck(IndexMetadata indexMetadata) {
        Boolean isIndexFrozen = (Boolean)FrozenEngine.INDEX_FROZEN.get(indexMetadata.getSettings());
        if (Boolean.TRUE.equals(isIndexFrozen)) {
            String indexName = indexMetadata.getIndex().getName();
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Freezing indices is deprecated", "https://ela.st/es-deprecation-7-frozen-indices", "Index [" + indexName + "] is frozen. Frozen indices no longer offer any advantages. Instead, unfreeze the index, make it read-only, and move it to the cold or frozen tier.", false, null);
        }
        return null;
    }

    static DeprecationIssue emptyDataTierPreferenceCheck(ClusterState clusterState, IndexMetadata indexMetadata) {
        List tierPreference;
        if (!DataTier.dataNodesWithoutAllDataRoles((ClusterState)clusterState).isEmpty() && (tierPreference = DataTier.parseTierList((String)((String)DataTier.TIER_PREFERENCE_SETTING.get(indexMetadata.getSettings())))).isEmpty()) {
            String indexName = indexMetadata.getIndex().getName();
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "No [index.routing.allocation.include._tier_preference] is set for index [" + indexName + "].", "https://ela.st/es-deprecation-7-empty-tier-preference", "Specify a data tier preference for this index.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkSettingNoReplacement(IndexMetadata indexMetadata, Setting<?> deprecatedSetting, String url) {
        return NodeDeprecationChecks.checkSettingNoReplacement(indexMetadata.getSettings(), deprecatedSetting, url);
    }

    static DeprecationIssue httpContentTypeRequiredSettingCheck(IndexMetadata indexMetadata) {
        Setting deprecatedSetting = Store.FORCE_RAM_TERM_DICT;
        String url = "https://ela.st/es-deprecation-7-force-memory-term-dictionary-setting";
        return IndexDeprecationChecks.checkRemovedSetting(indexMetadata.getSettings(), deprecatedSetting, url, "This setting no longer has any effect.", DeprecationIssue.Level.CRITICAL);
    }

    static DeprecationIssue mapperDyamicSettingCheck(IndexMetadata indexMetadata) {
        Setting deprecatedSetting = MapperService.INDEX_MAPPER_DYNAMIC_SETTING;
        String url = "https://ela.st/es-deprecation-7-mapper-dynamic-setting";
        return IndexDeprecationChecks.checkSettingNoReplacement(indexMetadata, deprecatedSetting, url);
    }

    static {
        HashSet<String> typesThatDontCount = new HashSet<String>();
        typesThatDontCount.add("binary");
        typesThatDontCount.add("geo_point");
        typesThatDontCount.add("geo_shape");
        TYPES_THAT_DONT_COUNT = Collections.unmodifiableSet(typesThatDontCount);
    }
}

